/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef AXIS_LABEL_INCLUDED
#define AXIS_LABEL_INCLUDED

#include <QtCore/QList>
#include <QtCore/QString>

#include "abstractoption.h"

//! set {axis}label コマンド
class AxisLabel : public AbstractOption
{
	public:
		AxisLabel();

		void setLabel(int axis, const QString &label);
		const QString &label(int axis) const;

		void setXOffset(int axis, double xoff);
		double xOffset(int axis) const;

		void setYOffset(int axis, double yoff);
		double yOffset(int axis) const;

		void setFontName(int axis, const QString &name);
		const QString &fontName(int axis) const;

		void setFontSize(int axis, double size);
		double fontSize(int axis) const;

		void setLineType(int axis, int lt);
		int lineType(int axis) const;

		QString command() const;

		//! 軸
		static const QString AXIS[];
	private:
		static const double DEFAULT_FONT_SIZE;
		static const int DEFAULT_LINE_TYPE;
		QList<QString> labelList;
		QList<double> xOffsetList;
		QList<double> yOffsetList;
		QList<QString> fontNameList;
		QList<double> fontSizeList;
		QList<int> lineTypeList;
};
#endif // AXIS_LABEL_INCLUDED
