/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "boxwidth.h"

#include <QtCore/QString>

const double BoxWidth::DEFAULT_WIDTH = -2.0;

BoxWidth::BoxWidth() : width_(DEFAULT_WIDTH), isAbsolute_(true)
{
}

void BoxWidth::setAuto(bool flag)
{
	if (flag) {
		width_ = DEFAULT_WIDTH;
		isAbsolute_ = true;
	}
}

bool BoxWidth::isAuto() const
{
	return width_ == DEFAULT_WIDTH && isAbsolute_;
}

void BoxWidth::setWidth(double width)
{
	width_ = width;
}

double BoxWidth::width() const
{
	return width_;
}

void BoxWidth::setAbsolute(bool absolute)
{
	isAbsolute_ = absolute;
}

bool BoxWidth::isAbsolute() const
{
	return isAbsolute_;
}

QString BoxWidth::command() const
{
	QString str = "set boxwidth ";
	if (isAuto()) {
		return str;
	}
	str += QString::number(width_) + ' '; 
	str += isAbsolute_ ? "absolute" : "relative";
	return str;
}
