/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef KEY_INCLUDED
#define KEY_INCLUDED

#include <QtCore/QList>
#include <QtCore/QString>

#include "abstractoption.h"

//! set key コマンド
class Key : public AbstractOption
{
	public:
		Key();

		void setOn(bool on);
		bool isOn() const;

		void setPosition(int pos);
		int position() const;

		void setPosition(int axis, double pos);
		double position(int axis) const;

		void setLeftJustification(bool leftJustify);
		bool leftJustification() const;

		void setReverse(bool reverse);
		bool isReverse() const;

		void setSampleLength(double length);
		double sampleLength() const;

		void setVerticalSpacing(double spacing);
		double verticalSpacing() const;

		void setWidthIncrement(double incr);
		double widthIncrement() const;

		void setHeightIncrement(double incr);
		double heightIncrement() const;

		void setAutoTitles(bool autoTitles);
		bool isAutoTitles() const;

		void setTitle(const QString &text);
		const QString &title() const;

		void setEnhanced(bool enhanced);
		bool enhances() const;

		void setBox(bool box);
		bool isBox() const;

		void setLineType(int lt);
		int lineType() const;

		void setLineWidth(double lw);
		double lineWidth() const;

		QString command() const;

		//! 軸
		static const QString AXIS[];
		//! 凡例の位置
		static const char * const POSITION[];

	private:
		static const int DEFAULT_LINE_TYPE = -2;

		bool isOn_;
		// left = 0x01, right = 0x02, top = 0x04,
		// bottom = 0x08, outside = 0x10, below = 0x20
		// x, y, z -> 0
		int position_;
		QList<double> positionList;
		bool leftJustification_;
		bool isReverse_;
		double sampleLength_;
		double verticalSpacing_;
		double widthIncrement_;
		double heightIncrement_;
		bool isAutoTitles_;
		QString title_;
		bool enhances_;
		int lineType_;
		double lineWidth_;
};
#endif // KEY_INCLUDED
