/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "maxistics.h"

#include <QtCore/QStringList>

const QString MAxisTics::AXIS[] = {
	"x", "y", "z", "x2", "y2", "cb", ""
};

MAxisTics::MAxisTics()
{
	for (int i = 0; !AXIS[i].isEmpty(); i++) {
		defaultList.append(true);
		freqList.append("");
	}
}

void MAxisTics::setDefault(int axis, bool flag)
{
	Q_ASSERT_X(axis >= 0
		&& axis < static_cast<int>(sizeof(AXIS) / sizeof(AXIS[0]) - 1),
		"MAxisTics::setDefault", "index out of range");
	defaultList[axis] = flag;
}

bool MAxisTics::isDefault(int axis) const
{
	Q_ASSERT_X(axis >= 0
		&& axis < static_cast<int>(sizeof(AXIS) / sizeof(AXIS[0]) - 1),
		"MAxisTics::isDefault", "index out of range");
	return defaultList.at(axis);
}

void MAxisTics::setFrequency(int axis, const QString &freq)
{
	Q_ASSERT_X(axis >= 0
		&& axis < static_cast<int>(sizeof(AXIS) / sizeof(AXIS[0]) - 1),
		"MAxisTics::setFrequency", "index out of range");
	freqList[axis] = freq;
}

const QString &MAxisTics::frequency(int axis) const
{
	Q_ASSERT_X(axis >= 0
		&& axis < static_cast<int>(sizeof(AXIS) / sizeof(AXIS[0]) - 1),
		"MAxisTics::frequency", "index out of range");
	return freqList.at(axis);
}

QString MAxisTics::command() const
{
	QStringList commandList;
	for (int i = 0; !AXIS[i].isEmpty(); i++) {
		QString str = "set m" + AXIS[i] + "tics ";
		if (defaultList.at(i)) {
			str += "default";
		} else {
			str += freqList.at(i);
		}
		commandList << str;
	}
	return commandList.join("\n");
}
