/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef OUTPUT_INCLUDED
#define OUTPUT_INCLUDED

#include <QtCore/QString>

#include "abstractoption.h"

//! set output コマンド
class Output : public AbstractOption
{
	public:
		Output();

		/*!
		 * \brief 出力するファイル名を設定する
		 * \param name 設定するファイル名
		 */
		void setFileName(const QString &name);
		/*!
		 * \brief 出力するファイル名を得る
		 * \return ファイル名
		 */
		const QString &fileName() const;

		QString command() const;
	private:
		QString fileName_;
};
#endif // OUTPUT_INCLUDED
