/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "samples.h"

#include <QtCore/QString>

Samples::Samples() : samples1_(100), samples2_(100)
{
}

void Samples::setSamples1(int num)
{
	samples1_ = num;
}

int Samples::samples1() const
{
	return samples1_;
}

void Samples::setSamples2(int num)
{
	samples2_ = num;
}

int Samples::samples2() const
{
	return samples2_;
}

QString Samples::command() const
{
	return "set samples " + QString::number(samples1_) + ','
		+ QString::number(samples2_);
}
