/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "size.h"

#include <QtCore/QString>

Size::Size() : ratio_(0.0), xScale_(1.0), yScale_(1.0)
{
}

void Size::setSquare(bool square)
{
	ratio_ = square ? 1.0 : 0.0;
}

bool Size::isSquare() const
{
	return ratio_ == 1.0;
}

void Size::setRatio(double r)
{
	ratio_ = r;
}

double Size::ratio() const
{
	return ratio_;
}

void Size::setXScale(double x)
{
	xScale_ = x;
}

double Size::xScale() const
{
	return xScale_;
}

void Size::setYScale(double y)
{
	yScale_ = y;
}

double Size::yScale() const
{
	return yScale_;
}

void Size::setNoRatio(bool no)
{
	if (no) {
		ratio_ = 0.0;
	}
}

bool Size::isNoRatio() const
{
	return ratio_ == 0.0;
}

QString Size::command() const
{
	return "set size ratio " + QString::number(ratio_)
		+ ' ' + QString::number(xScale_) 
		+ ',' + QString::number(yScale_);
}
