/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef STYLE_FILL_INCLUDED
#define STYLE_FILL_INCLUDED

#include "abstractoption.h"

//! set style fill コマンド
class StyleFill : public AbstractOption
{
	public:
		StyleFill();

		/// 塗りつぶさないように設定する
		void setEmpty();
		/*!
		 * \brief 塗りつぶさないかどうかを設定する
		 * \return 塗りつぶさないならば true
		 */
		bool isEmpty() const;

		/// 無地で塗りつぶすように設定する
		void setSolid();
		/*!
		 * \brief 無地で塗りつぶすかどうかを設定する
		 * \return 無地で塗りつぶすならば true
		 */
		bool isSolid() const;

		/*!
		 * \brief 塗りつぶしの濃さを設定する
		 * \param density 設定する塗りつぶしの濃さ
		 */
		void setDensity(double density);
		/*!
		 * \brief 塗りつぶしの濃さを得る
		 * \return 塗りつぶしの濃さ
		 */
		double density() const;

		/// パターンで塗りつぶすように設定する
		void setPattern();
		/*!
		 * \brief パターンで塗りつぶすかどうかを設定する
		 * \return パターンで塗りつぶすならば true
		 */
		bool isPattern() const;

		/*!
		 * \brief 塗りつぶしのパターンを設定する
		 * \param n 設定する塗りつぶしのパターン
		 */
		void setPattern(int n);
		/*!
		 * \brief 塗りつぶしのパターンを得る
		 * \return 塗りつぶしのパターン
		 */
		int pattern() const;

		/*!
		 * \brief 境界線を表示するかどうかを設定する
		 * \param border 境界線を表示するかどうか
		 */
		void setBorder(bool border);
		/*!
		 * \brief 境界線を表示するかどうかを返す
		 * \return 境界線を表示するならば true
		 */
		bool isBorder() const;

		/*!
		 * \brief 境界線の種類を設定する
		 * \param type 設定する境界線の種類
		 */
		void setLineType(int type);
		/*!
		 * \brief 境界線の種類を得る
		 * \return 境界線の種類
		 */
		int lineType() const;

		QString command() const;

	private:
		static const int EMPTY;
		static const int SOLID;
		static const int PATTERN;

		static const int DEFAULT_LINE_TYPE;

		int style_;
		double density_;
		int pattern_;
		bool isBorder_;
		int lineType_;
};
#endif // STYLE_FILL_INCLUDED
