/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008, 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "terminal.h"

const QString Terminal::TERMINALS[] = {
	"aifm",
#ifdef Q_OS_DARWIN
	"aqua",
#endif
	"cgm", "corel", "dumb", "dxf", "eepic", "emf", "emtex", "epslatex",
	"fig", "hp2623A", "hp2648", "hp500c", "hpgl", "hpljii", "imagen", "latex",
	"mif", "pbm", "postscript", "pslatex", "pstricks", "qms", "svg", "table", 
	"texdraw", "tgif", "tkcanvas", "tpic", "unknown", 
#if defined(Q_OS_WIN32)
	"windows",
#elif defined(Q_OS_UNIX)
	"x11",
#endif
	""
};

const QString Terminal::TERMINALS_WITH_OPTIONS[] = {
	"emtex", "latex", "pbm", "postscript", ""
};

Terminal::Terminal() : status(TERMINAL)
{
	QByteArray gnuTerm = qgetenv("GNUTERM");
	if (!gnuTerm.isEmpty()) {
		terminalType_ = gnuTerm;
	} else {
#if defined(Q_OS_DARWIN)
		terminalType_ = "aqua";
#elif defined(Q_OS_UNIX)
		terminalType_ = "x11";
#elif defined(Q_OS_WIN32)
		terminalType_ = "windows";
#else
		terminalType_ = "unknown";
#endif
	}
}

void Terminal::setTerminalType(const QString &type)
{
	terminalType_ = type;
	status = TERMINAL;
}

const QString &Terminal::terminalType() const
{
	return terminalType_;
}

void Terminal::setPush()
{
	status = PUSH;
}

void Terminal::setPop()
{
	status = POP;
}

QString Terminal::terminalOption() const
{
	return "";
}

QString Terminal::command() const
{
	QString str = "set terminal ";
	switch (status) {
	case TERMINAL:
		str += terminalType_;
		{
			QString option = terminalOption();
			if (!option.isEmpty()) {
				str += ' ' + option;
			}
		}
		break;
	case PUSH:
		str += "push";
		break;
	case POP:
		str += "pop";
		break;
	}

	return str;
}
