/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef TERMINAL_LATEX_EMTEX_INCLUDED
#define TERMINAL_LATEX_EMTEX_INCLUDED

#include <QtCore/QString>

#include "terminal.h"

//! set terminal latex | emtex コマンド
class TerminalLatexEmtex : public Terminal
{
	public:
		TerminalLatexEmtex();

		/*!
		 * \brief 端末を LaTeX にするかどうかを設定する
		 * \param latex 端末を emTeX ではなく LaTeX にするかどうか
		 */
		void setLatex(bool latex);
		/*!
		 * \brief 端末が LaTeX かどうかを返す
		 * \return 端末が emTeX ではなく LaTeX ならば true
		 */
		bool isLatex() const;

		/*!
		 * \brief フォントの名前を設定する
		 * \param name 設定するフォントの名前
		 * \sa TerminalLatexEmtex::FONT_NAME
		 */
		void setFontName(int name);
		/*!
		 * \brief フォントの名前を得る
		 * \return フォントの名前
		 * \sa TerminalLatexEmtex::FONT_NAME
		 */
		int fontName() const;

		/*!
		 * \brief フォントのサイズを設定する
		 * \param size 設定するフォントのサイズ
		 */
		void setFontSize(int size);
		/*!
		 * \brief フォントのサイズを得る
		 * \return フォントのサイズ
		 */
		int fontSize() const;

		//! フォント名
		static const char * const FONT_NAME[];

	private:
		QString terminalOption() const;
		static const int DEFAULT_FONT_SIZE;
		bool isLatex_;
		// default = 0x00, courier = 0x01, roman = 0x02
		int fontName_;
		int fontSize_;
};
#endif // TERMINAL_LATEX_EMTEX_INCLUDED
