/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef TERMINAL_PBM_INCLUDED
#define TERMINAL_PBM_INCLUDED

class QString;

#include "terminal.h"

//! set terminal pbm コマンド
class TerminalPbm : public Terminal
{
	public:
		TerminalPbm();

		/*!
		 * \brief フォントのサイズを設定する
		 * \param size 設定するフォントのサイズ
		 * \sa TerminalPbm::FONT_SIZE
		 */
		void setFontSize(int size);
		/*!
		 * \brief フォントのサイズを得る
		 * \return フォントのサイズ
		 * \sa TerminalPbm::FONT_SIZE
		 */
		int fontSize() const;

		/*!
		 * \brief モードを設定する
		 * \param mode 設定するモード
		 * \sa TerminalPbm::MODE
		 */
		void setMode(int mode);
		/*!
		 * \brief モードを得る
		 * \return モード
		 * \sa TerminalPbm::MODE
		 */
		int mode() const;

		//! フォントのサイズ
		static const char * const FONT_SIZE[];
		//! モード（色）
		static const char * const MODE[];

	private:
		QString terminalOption() const;
		int fontSize_;
		int mode_;
};
#endif // TERMINAL_PBM_INCLUDED
