/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "terminalpostscript.h"

const char * const TerminalPostScript::MODE[] = {
	QT_TRANSLATE_NOOP("TerminalPostScript", "landscape"),
	QT_TRANSLATE_NOOP("TerminalPostScript", "portrait"),
	"eps",
	""
};

const char * const TerminalPostScript::COLOR[] = {
	QT_TRANSLATE_NOOP("TerminalPostScript", "color"),
	QT_TRANSLATE_NOOP("TerminalPostScript", "monochrome"),
	""
};

const char * const TerminalPostScript::LINE_STYLE[] = {
	QT_TRANSLATE_NOOP("TerminalPostScript", "solid"),
	QT_TRANSLATE_NOOP("TerminalPostScript", "dashed"),
	""
};

TerminalPostScript::TerminalPostScript() : mode_(0), enhances_(false), 
	isColor_(false), isBlackText_(true), isSolid_(false),
	dashLength_(1.0), lineWidth_(1.0), duplexing_(0), rounds_(false),
	samples_(2000), maxDeviation_(0.003), fontName_("Helvetica"),
	fontSize_(14)
{
	terminalType_ = "postscript";
}

void TerminalPostScript::setMode(int mode)
{
	mode_ = mode;
}

int TerminalPostScript::mode() const
{
	return mode_;
}

void TerminalPostScript::setEnhanced(bool enhanced)
{
	enhances_ = enhanced;
}

bool TerminalPostScript::enhances() const
{
	return enhances_;
}

void TerminalPostScript::setColor(bool color)
{
	isColor_ = color;
}

bool TerminalPostScript::isColor() const
{
	return isColor_;
}

void TerminalPostScript::setBlackText(bool black)
{
	isBlackText_ = black;
}

bool TerminalPostScript::isBlackText() const
{
	return isBlackText_;
}

void TerminalPostScript::setSolid(bool solid)
{
	isSolid_ = solid;
}

bool TerminalPostScript::isSolid() const
{
	return isSolid_;
}

void TerminalPostScript::setDashLength(double dl)
{
	dashLength_ = dl;
}

double TerminalPostScript::dashLength() const
{
	return dashLength_;
}

void TerminalPostScript::setLineWidth(double lw)
{
	lineWidth_ = lw;
}

double TerminalPostScript::lineWidth() const
{
	return lineWidth_;
}

void TerminalPostScript::setDuplexing(int duplex)
{
	duplexing_ = duplex;
}

int TerminalPostScript::duplexing() const
{
	return duplexing_;
}

void TerminalPostScript::setRounded(bool round)
{
	rounds_ = round;
}

bool TerminalPostScript::rounds() const
{
	return rounds_;
}

void TerminalPostScript::setFontFile(const QString &fileName, bool add)
{
	if (add) {
		if (fontFileList.contains(fileName)) {
			fontFileList << fileName;
		}
	} else {
		fontFileList.removeAll(fileName);
	}
}

const QStringList &TerminalPostScript::fontFile() const
{
	return fontFileList;
}

void TerminalPostScript::setPalFuncParam(int samples, double maxdeviation)
{
	samples_ = samples;
	maxDeviation_ = maxdeviation;
}

int TerminalPostScript::samples() const
{
	return samples_;
}

double TerminalPostScript::maxDeviation() const
{
	return maxDeviation_;
}

void TerminalPostScript::setFontName(const QString &name)
{
	fontName_ = name;
}

const QString &TerminalPostScript::fontName() const
{
	return fontName_;
}

void TerminalPostScript::setFontSize(int size)
{
	fontSize_ = size;
}

int TerminalPostScript::fontSize() const
{
	return fontSize_;
}

QString TerminalPostScript::terminalOption() const
{
	const QString DUPLEXING[] 
		= { "defaultplex", "simplex", "duplex" };
	QString str = QString(MODE[mode_]) + ' ';
	str += enhances_ ? "" : "no";
	str += "enhanced ";
	str += COLOR[!isColor_];
	str += ' ';
	str += isBlackText_ ? "blacktext" : "colortext";
	str += ' ';
	str += LINE_STYLE[!isSolid_];
	str += " dashlength " + 
		QString::number(dashLength_)
		+ " linewidth " + QString::number(lineWidth_)
		+ ' ' + DUPLEXING[duplexing_] + " palfuncparam "
		+ QString::number(samples_) + ','
		+ QString::number(maxDeviation_) + ' ';
	str += rounds_ ? "rounded" : "butt";
	str += " \"" + fontName_ + "\" " 
		+ QString::number(fontSize_);
	return str;
}
