/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "view.h"

#include <QtCore/QString>

View::View() : isMap_(false), rotX(60), rotZ(30), scale(1), scaleZ(1)
{
}

void View::setMap(bool map)
{
	isMap_ = map;
}

bool View::isMap() const
{
	return isMap_;
}

void View::setRotationX(double x)
{
	rotX = x;
}

double View::rotationX() const
{
	return rotX;
}

void View::setRotationZ(double z)
{
	rotZ = z;
}

double View::rotationZ() const
{
	return rotZ;
}

void View::setScaling(double s)
{
	scale = s;
}

double View::scaling() const
{
	return scale;
}

void View::setScalingZ(double sZ)
{
	scaleZ = sZ;
}

double View::scalingZ() const
{
	return scaleZ;
}

QString View::command() const
{
	QString str = "set view ";
	if (isMap_) {
		return str + "map";
	}
	return str + QString::number(rotX) + ',' + QString::number(rotZ)
		+ ',' + QString::number(scale) + ',' + QString::number(scaleZ);
}
