/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "stylefill.h"

#include <QtCore/QString>

int stylefilltest(int, char *[])
{
	StyleFill styleFill;
	if (!styleFill.isEmpty()) {
		return 1;
	}
	if (!styleFill.isBorder()) {
		return 1;
	}
	if (styleFill.command() != "set style fill empty border") {
		return 1;
	}
	styleFill.setSolid();
	if (styleFill.command() != "set style fill solid 1 border") {
		return 1;
	}
	styleFill.setDensity(0.25);
	if (styleFill.command() != "set style fill solid 0.25 border") {
		return 1;
	}
	styleFill.setPattern();
	if (styleFill.command() != "set style fill pattern 0 border") {
		return 1;
	}
	styleFill.setPattern(2);
	if (styleFill.command() != "set style fill pattern 2 border") {
		return 1;
	}
	styleFill.setBorder(false);
	if (styleFill.command() != "set style fill pattern 2 noborder") {
		return 1;
	}
	styleFill.setLineType(2);
	if (styleFill.command() != "set style fill pattern 2 noborder") {
		return 1;
	}
	styleFill.setBorder(true);
	if (styleFill.command() != "set style fill pattern 2 border 2") {
		return 1;
	}
	return 0;
}
