/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "terminallatexemtex.h"

#include <cstring> // strcmp()

int terminallatexemtextest(int, char *[])
{
	TerminalLatexEmtex terminalLatexEmtex;
	if (!terminalLatexEmtex.isLatex()) {
		return 1;
	}
	if (terminalLatexEmtex.fontName() != 2) {
		return 1;
	}
	if (terminalLatexEmtex.command() != "set terminal latex") {
		return 1;
	}
	terminalLatexEmtex.setLatex(false);
	if (terminalLatexEmtex.command() != "set terminal emtex") {
		return 1;
	}
	terminalLatexEmtex.setLatex(true);
	if (terminalLatexEmtex.command() != "set terminal latex") {
		return 1;
	}
	terminalLatexEmtex.setFontName(0);
	if (terminalLatexEmtex.fontSize() != 10) {
		return 1;
	}
	if (terminalLatexEmtex.command() != "set terminal latex courier 10") {
		return 1;
	}
	if (std::strcmp(TerminalLatexEmtex::FONT_NAME[0], "courier")) {
		return 1;
	}
	terminalLatexEmtex.setFontName(1);
	if (terminalLatexEmtex.command() != "set terminal latex roman 10") {
		return 1;
	}
	if (std::strcmp(TerminalLatexEmtex::FONT_NAME[1], "roman")) {
		return 1;
	}
	terminalLatexEmtex.setFontSize(12);
	if (terminalLatexEmtex.command() != "set terminal latex roman 12") {
		return 1;
	}
	return 0;
}
