/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2009 Muneyuki Noguchi <nogu@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "terminalpbm.h"

#include <cstring> // strcmp()

int terminalpbmtest(int, char *[])
{
	TerminalPbm terminalPbm;
	if (terminalPbm.command() != "set terminal pbm small monochrome") {
		return 1;
	}
	terminalPbm.setFontSize(0);
	if (terminalPbm.command() != "set terminal pbm small monochrome") {
		return 1;
	}
	if (std::strcmp(TerminalPbm::FONT_SIZE[0], "small")) {
		return 1;
	}
	terminalPbm.setFontSize(1);
	if (terminalPbm.command() != "set terminal pbm medium monochrome") {
		return 1;
	}
	if (std::strcmp(TerminalPbm::FONT_SIZE[1], "medium")) {
		return 1;
	}
	terminalPbm.setFontSize(2);
	if (terminalPbm.command() != "set terminal pbm large monochrome") {
		return 1;
	}
	if (std::strcmp(TerminalPbm::FONT_SIZE[2], "large")) {
		return 1;
	}
	terminalPbm.setMode(0);
	if (terminalPbm.command() != "set terminal pbm large monochrome") {
		return 1;
	}
	if (std::strcmp(TerminalPbm::MODE[0], "monochrome")) {
		return 1;
	}
	terminalPbm.setMode(1);
	if (terminalPbm.command() != "set terminal pbm large gray") {
		return 1;
	}
	if (std::strcmp(TerminalPbm::MODE[1], "gray")) {
		return 1;
	}
	terminalPbm.setMode(2);
	if (terminalPbm.command() != "set terminal pbm large color") {
		return 1;
	}
	if (std::strcmp(TerminalPbm::MODE[2], "color")) {
		return 1;
	}
	return 0;
}
