#ifndef _TEST_RUNNER_H_
#define _TEST_RUNNER_H_

/** Assert single */
#define TEST_ASSERT(_a) \
    {\
        int assertErrorA = (_a);\
        if (! assertErrorA) {\
            fprintf(stdout,"%s:%d: error: TestCaseError(0x%08x)\n",\
                __FILE__,__LINE__,(assertErrorA));\
            return 0xffffffffu;\
        } else {\
            doTestCountUp();\
        }\
    }

/** Assert equals */
#define TEST_ASSERT_EQUALS(_a,_b) \
    {\
        int assertErrorA = (_a);\
        int assertErrorB = (_b);\
        if ((assertErrorA) != (assertErrorB)) {\
            fprintf(stdout,"%s:%d: error: TestCaseError<0x%08x><0x%08x>\n",\
                __FILE__,__LINE__,(assertErrorA),(assertErrorB));\
            return 0xffffffffu;\
        } else {\
            doTestCountUp();\
        }\
    }

/** Assert equals */
#define TEST_ASSERT_NOT_EQUALS(_a,_b) \
    {\
        int assertErrorA = (_a);\
        int assertErrorB = (_b);\
        if ((assertErrorA) == (assertErrorB)) {\
            fprintf(stdout,"%s:%d: error: TestCaseError<0x%08x><0x%08x>\n",\
                __FILE__,__LINE__,(assertErrorA),(assertErrorB));\
            return 0xffffffffu;\
        } else {\
            doTestCountUp();\
        }\
    }

/** File pointer define */
typedef unsigned int (*TEST_FUNCTION)(void);

/** Test runner. */
unsigned int testRunner(TEST_FUNCTION testFunction);

/** Test counter */
void doTestCountUp(void);

#endif 
