#include "select.h"

/** @see select.h */
unsigned int hardAccsess(
    unsigned int address,
    unsigned int data,
    HARD_TYPE_t select) {
    unsigned int err = 0;
    switch (select) {
    case HARD_TYPE_A:
        err = setDataA(address,data);
        break;
    case HARD_TYPE_B:
    default:
        if ((data & 0xffff0000u) != 0) {
            err = 1;
        } else {
            writeAccessB(address,(unsigned short)data);
        }
        break;
    }
    return err;
}
