#include <stdio.h>
#include <testRunner.h>
#include "select.h"

/* A test is divided. */
static unsigned int testAll(void);
static unsigned int testHardA(void);
static unsigned int testHardB(void);

/* A domain is secured. */
static unsigned int inSetDataA_address;
static unsigned int inSetDataA_data;
static unsigned int returnSetDataA;
static unsigned int inWriteAccessB_address;
static unsigned short inWriteAccessB_data;

int main(int argc,char **argv) {
    return (int) testRunner(testAll);
}

static unsigned int testAll(void) {
    TEST_ASSERT(! testHardA());
    TEST_ASSERT(! testHardB());
    return 0;
}

static unsigned int testHardA(void) {
    unsigned int err;
    unsigned int address;
    unsigned int data;
    HARD_TYPE_t select;
    
    /////////////////////////////////////////////////
    // setDataA normal
    address = 0x85000038u; // 0x0-ffffffffu
    data = 456; // 0x0-ffffffffu
    select = HARD_TYPE_A; // HARD_TYPE_A,HARD_TYPE_B
    inSetDataA_address = 0xffffffffu;// imput(dirty)
    inSetDataA_data = 0xffffffffu;// imput(dirty)
    returnSetDataA = 0; // 0:normal,1-0xffffffffu:abnormal
    inWriteAccessB_address = 0xffffffffu; // imput(dirty)
    inWriteAccessB_data = 0xffffu; // imput(dirty)
    
    err = hardAccsess(address,data,select); // do test
    
    TEST_ASSERT_EQUALS(err,0); // normal
    TEST_ASSERT_EQUALS(inSetDataA_address,(int)address); // Check!
    TEST_ASSERT_EQUALS(inSetDataA_data,(int)data); // Check!
    TEST_ASSERT_EQUALS(inWriteAccessB_address,(int)0xffffffffu); // no access
    TEST_ASSERT_EQUALS(inWriteAccessB_data,0xffffu); // no access

    /////////////////////////////////////////////////
    // setDataA abnormal
    address = 0x86540004u; // 0x0-ffffffffu
    data = 22; // 0x0-ffffffffu
    select = HARD_TYPE_A; // HARD_TYPE_A,HARD_TYPE_B
    inSetDataA_address = 0xffffffffu;// imput(dirty)
    inSetDataA_data = 0xffffffffu;// imput(dirty)
    returnSetDataA = 0x31u; // 0:normal,1-0xffffffffu:abnormal
    inWriteAccessB_address = 0xffffffffu; // imput(dirty)
    inWriteAccessB_data = 0xffffu; // imput(dirty)
    
    err = hardAccsess(address,data,select); // do test
    
    TEST_ASSERT(err != 0); // abnormal
    TEST_ASSERT_EQUALS(inSetDataA_address,(int)address); // Check!
    TEST_ASSERT_EQUALS(inSetDataA_data,(int)data); // Check!
    TEST_ASSERT_EQUALS(inWriteAccessB_address,(int)0xffffffffu); // no access
    TEST_ASSERT_EQUALS(inWriteAccessB_data,0xffffu); // no access
    return 0;
}

static unsigned int testHardB(void) {
    unsigned int err;
    unsigned int address;
    unsigned int data;
    HARD_TYPE_t select;

    /////////////////////////////////////////////////
    // writeAccessB normal
    address = 0x36540004u; // 0x0-ffffffffu
    data = 22; // 0x0-0000ffffu:normal,0x00010000-0xffff0000:abnormal
    select = HARD_TYPE_B; // HARD_TYPE_A,HARD_TYPE_B
    inSetDataA_address = 0xffffffffu;// imput(dirty)
    inSetDataA_data = 0xffffffffu;// imput(dirty)
    returnSetDataA = 0; // 0:normal,1-0xffffffffu:abnormal
    inWriteAccessB_address = 0xffffffffu; // imput(dirty)
    inWriteAccessB_data = 0xffffu; // imput(dirty)
    
    err = hardAccsess(address,data,select); // do test
    
    TEST_ASSERT_EQUALS(err , 0); // normal
    TEST_ASSERT_EQUALS(inSetDataA_address,(int)0xffffffffu); // no access
    TEST_ASSERT_EQUALS(inSetDataA_data,(int)0xffffffffu); // no access
    TEST_ASSERT_EQUALS(inWriteAccessB_address,(int)address); // Check!
    TEST_ASSERT_EQUALS(inWriteAccessB_data,data); // Check!
    
    /////////////////////////////////////////////////
    // writeAccessB abnormal
    address = 0x36500027u; // 0x0-ffffffffu
    data = 0x04000003u; // 0x0-0000ffffu:normal,0x00010000-0xffff0000:abnormal
    select = HARD_TYPE_B; // HARD_TYPE_A,HARD_TYPE_B
    inSetDataA_address = 0xffffffffu;// imput(dirty)
    inSetDataA_data = 0xffffffffu;// imput(dirty)
    returnSetDataA = 0; // 0:normal,1-0xffffffffu:abnormal
    inWriteAccessB_address = 0xffffffffu; // imput(dirty)
    inWriteAccessB_data = 0xffffu; // imput(dirty)
    
    err = hardAccsess(address,data,select);
    
    TEST_ASSERT(err != 0); // abnormal
    TEST_ASSERT_EQUALS(inSetDataA_address,(int)0xffffffffu); // no access
    TEST_ASSERT_EQUALS(inSetDataA_data,(int)0xffffffffu); // no access
    TEST_ASSERT_EQUALS(inWriteAccessB_address,(int)0xffffffffu); // no access
    TEST_ASSERT_EQUALS(inWriteAccessB_data,0xffffu); // no access
    return 0;
}

/** Unit A Access driver. */
unsigned int setDataA(
    unsigned int address,unsigned int data) {
    inSetDataA_address = address;
    inSetDataA_data = data;
    return returnSetDataA;
}

/** Unit B Access driver. */
void writeAccessB(
    unsigned int address,unsigned short data) {
    inWriteAccessB_address = address;
    inWriteAccessB_data = data;
}

