#include <stdio.h>
#include <string.h>
#include <testRunner.h>
#include "select.h"
#include "loop.h"

/* A domain is secured. */
#define DATA_ARRAY 100
static unsigned int inSetDataA_address[DATA_ARRAY];
static unsigned int inSetDataA_data[DATA_ARRAY];
static unsigned int returnSetDataA[DATA_ARRAY];
static unsigned int countSetDataA = 0;

static unsigned int testLoop(void);

/** Main function. */
int main() {
    return (int) testRunner(testLoop);
}

static unsigned int testLoop(void) {
    unsigned int err;
    unsigned int i;
    
    /////////////////////////////////////////////////
    // normal
    memset(inSetDataA_address,0xffffffffu,sizeof(unsigned int)*DATA_ARRAY);
    memset(inSetDataA_data,0xffffffffu,sizeof(unsigned int)*DATA_ARRAY);
    memset(returnSetDataA,0,sizeof(unsigned int)*DATA_ARRAY);
    countSetDataA = 0;
    
    err = loop(); // do test
    
    TEST_ASSERT_EQUALS(err,0); // normal
    TEST_ASSERT_EQUALS(countSetDataA,10); //
    for (i = 0 ; i < 10 ; i++) {
        TEST_ASSERT_EQUALS(inSetDataA_address[i] ,(int) (0x85000000u + (i + 8)));
        TEST_ASSERT_EQUALS(inSetDataA_data[i] ,(int) i);
    }

    /////////////////////////////////////////////////
    // abnormal
    memset(inSetDataA_address,0xffffffffu,sizeof(unsigned int)*DATA_ARRAY);
    memset(inSetDataA_data,0xffffffffu,sizeof(unsigned int)*DATA_ARRAY);
    memset(returnSetDataA,0,sizeof(unsigned int)*DATA_ARRAY);
    returnSetDataA[3] = 5; // A mistake is mixed.
    countSetDataA = 0;
    
    err = loop(); // do test
    
    TEST_ASSERT(err != 0); // abnormal
    // Even if there is an error, a hard setup has run
    TEST_ASSERT_EQUALS(countSetDataA,10);
    for (i = 0 ; i < 10 ; i++) {
        TEST_ASSERT_EQUALS(inSetDataA_address[i] ,(int) (0x85000000u + (i + 8)));
        TEST_ASSERT_EQUALS(inSetDataA_data[i] ,(int) i);
    }
    return 0;
}

/** Unit A Access driver. */
unsigned int setDataA(
    unsigned int address,unsigned int data) {
    inSetDataA_address[countSetDataA] = address;
    inSetDataA_data[countSetDataA] = data;
    countSetDataA++;
    return returnSetDataA[countSetDataA];
}

