/*
 * Decompiled with CFR 0.152.
 */
package org.curewallet.lib.api.impl;

import org.curewallet.lib.api.CoinAPIException;
import org.curewallet.lib.api.GetRawTransaction;
import org.curewallet.lib.api.response.GetRawTransactionResponseObject1;
import org.curewallet.lib.api.response.GetRawTransactionResponseObject2;
import org.curewallet.lib.api.result.GetRawTransactionResult;
import org.curewallet.lib.jsonrpc.JsonRPCClient;
import org.curewallet.lib.jsonrpc.JsonRPCv1RequestObject;

public class GetRawTransactionImpl
implements GetRawTransaction {
    protected static final String METHOD = "getrawtransaction";

    @Override
    public GetRawTransactionResult call(JsonRPCClient jsonRPCClient, String transactionId) throws CoinAPIException {
        return this.call(jsonRPCClient, transactionId, null);
    }

    @Override
    public GetRawTransactionResult call(JsonRPCClient jsonRPCClient, String transactionId, Long verbose) throws CoinAPIException {
        try {
            if (jsonRPCClient == null) {
                throw new NullPointerException("jsonRPCClient is null.");
            }
            if (transactionId == null || transactionId.length() == 0) {
                throw new NullPointerException("transactionId is null or empty.");
            }
            JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
            requestObject.setMethod(METHOD);
            if (verbose == null) {
                requestObject.setParams(new Object[]{transactionId});
            } else {
                requestObject.setParams(new Object[]{transactionId, verbose});
            }
            if (verbose == null || verbose == 0L) {
                return jsonRPCClient.call(requestObject, GetRawTransactionResponseObject2.class).getResultObject();
            }
            return jsonRPCClient.call(requestObject, GetRawTransactionResponseObject1.class).getResultObject();
        }
        catch (Exception e) {
            throw new CoinAPIException("Error: " + e.getMessage(), e);
        }
    }
}

