/*
 * Decompiled with CFR 0.152.
 */
package org.curewallet.lib.api.impl;

import org.curewallet.lib.api.AbstractCoinAPI;
import org.curewallet.lib.api.CoinAPIException;
import org.curewallet.lib.api.GetTransaction;
import org.curewallet.lib.api.response.GetTransactionResponseObject;
import org.curewallet.lib.api.result.GetTransactionResult;
import org.curewallet.lib.jsonrpc.JsonRPCClient;
import org.curewallet.lib.jsonrpc.JsonRPCv1RequestObject;

public class GetTransactionImpl
extends AbstractCoinAPI
implements GetTransaction {
    protected static final String METHOD = "gettransaction";

    @Override
    public GetTransactionResult call(JsonRPCClient jsonRPCClient, String transactionId) throws CoinAPIException {
        try {
            if (jsonRPCClient == null) {
                throw new NullPointerException("jsonRPCClient is null.");
            }
            if (transactionId == null || transactionId.length() == 0) {
                throw new NullPointerException("transactionId is null or empty.");
            }
            JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
            requestObject.setMethod(METHOD);
            requestObject.setParams(new Object[]{transactionId});
            return jsonRPCClient.call(requestObject, GetTransactionResponseObject.class).getResultObject();
        }
        catch (Exception e) {
            throw new CoinAPIException("Error: " + e.getMessage(), e);
        }
    }
}

