/*
 * Decompiled with CFR 0.152.
 */
package org.curewallet.lib.api.impl;

import java.math.BigDecimal;
import org.curewallet.lib.api.AbstractCoinAPI;
import org.curewallet.lib.api.CoinAPIException;
import org.curewallet.lib.api.SendFrom;
import org.curewallet.lib.api.response.SendFromResponseObject;
import org.curewallet.lib.api.result.SendFromResult;
import org.curewallet.lib.jsonrpc.JsonRPCClient;
import org.curewallet.lib.jsonrpc.JsonRPCv1RequestObject;

public class SendFromImpl
extends AbstractCoinAPI
implements SendFrom {
    protected static final String METHOD = "sendfrom";

    @Override
    public SendFromResult call(JsonRPCClient jsonRPCClient, String fromAccount, String toAddress, BigDecimal amount) throws CoinAPIException {
        return this.call(jsonRPCClient, fromAccount, toAddress, amount, null, null, null);
    }

    @Override
    public SendFromResult call(JsonRPCClient jsonRPCClient, String fromAccount, String toAddress, BigDecimal amount, String comment, String commentTo) throws CoinAPIException {
        return this.call(jsonRPCClient, fromAccount, toAddress, amount, null, comment, commentTo);
    }

    @Override
    public SendFromResult call(JsonRPCClient jsonRPCClient, String fromAccount, String toAddress, BigDecimal amount, Long minconf) throws CoinAPIException {
        return this.call(jsonRPCClient, fromAccount, toAddress, amount, minconf, null, null);
    }

    @Override
    public SendFromResult call(JsonRPCClient jsonRPCClient, String fromAccount, String toAddress, BigDecimal amount, Long minconf, String comment, String commentTo) throws CoinAPIException {
        try {
            if (jsonRPCClient == null) {
                throw new NullPointerException("jsonRPCClient is null.");
            }
            if (fromAccount == null || fromAccount.length() == 0) {
                throw new NullPointerException("fromAccount is null.");
            }
            if (toAddress == null || fromAccount.length() == 0) {
                throw new NullPointerException("toAddress is null.");
            }
            if (amount == null) {
                throw new NullPointerException("amount is null.");
            }
            JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
            requestObject.setMethod(METHOD);
            if (minconf == null && comment == null && commentTo == null) {
                requestObject.setParams(new Object[]{fromAccount, toAddress, amount});
            } else {
                if (minconf == null) {
                    minconf = new Long(1L);
                }
                if (comment == null) {
                    comment = "";
                }
                if (commentTo == null) {
                    commentTo = "";
                }
                requestObject.setParams(new Object[]{fromAccount, toAddress, amount, minconf, comment, commentTo});
            }
            return jsonRPCClient.call(requestObject, SendFromResponseObject.class).getResultObject();
        }
        catch (Exception e) {
            throw new CoinAPIException("Error: " + e.getMessage(), e);
        }
    }
}

