/*
 * Decompiled with CFR 0.152.
 */
package org.curewallet.lib.api.impl;

import java.math.BigDecimal;
import java.util.Map;
import org.curewallet.lib.api.AbstractCoinAPI;
import org.curewallet.lib.api.CoinAPIException;
import org.curewallet.lib.api.SendMany;
import org.curewallet.lib.api.response.SendManyResponseObject;
import org.curewallet.lib.api.result.SendManyResult;
import org.curewallet.lib.jsonrpc.JsonRPCClient;
import org.curewallet.lib.jsonrpc.JsonRPCv1RequestObject;

public class SendManyImpl
extends AbstractCoinAPI
implements SendMany {
    protected static final String METHOD = "sendmany";

    @Override
    public SendManyResult call(JsonRPCClient jsonRPCClient, String fromAccount, Map<String, BigDecimal> addressAmount) throws CoinAPIException {
        return this.call(jsonRPCClient, fromAccount, addressAmount, null, null);
    }

    @Override
    public SendManyResult call(JsonRPCClient jsonRPCClient, String fromAccount, Map<String, BigDecimal> addressAmount, Long minconf) throws CoinAPIException {
        return this.call(jsonRPCClient, fromAccount, addressAmount, minconf, null);
    }

    @Override
    public SendManyResult call(JsonRPCClient jsonRPCClient, String fromAccount, Map<String, BigDecimal> addressAmount, String comment) throws CoinAPIException {
        return this.call(jsonRPCClient, fromAccount, addressAmount, null, comment);
    }

    @Override
    public SendManyResult call(JsonRPCClient jsonRPCClient, String fromAccount, Map<String, BigDecimal> addressAmount, Long minconf, String comment) throws CoinAPIException {
        try {
            if (jsonRPCClient == null) {
                throw new NullPointerException("jsonRPCClient is null.");
            }
            if (fromAccount == null || fromAccount.length() == 0) {
                throw new NullPointerException("fromAccount is null.");
            }
            if (addressAmount == null || addressAmount.size() == 0) {
                throw new NullPointerException("addressAmount is null.");
            }
            JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
            requestObject.setMethod(METHOD);
            if (minconf == null && comment == null) {
                requestObject.setParams(new Object[]{fromAccount, addressAmount});
            } else {
                if (minconf == null) {
                    minconf = new Long(1L);
                }
                if (comment == null) {
                    comment = "";
                }
                requestObject.setParams(new Object[]{fromAccount, addressAmount, minconf, comment});
            }
            return jsonRPCClient.call(requestObject, SendManyResponseObject.class).getResultObject();
        }
        catch (Exception e) {
            throw new CoinAPIException("Error: " + e.getMessage(), e);
        }
    }
}

