/*
 * Decompiled with CFR 0.152.
 */
package org.curewallet.lib.api.impl;

import org.curewallet.lib.api.AbstractCoinAPI;
import org.curewallet.lib.api.CoinAPIException;
import org.curewallet.lib.api.ValidateAddress;
import org.curewallet.lib.api.response.ValidateAddressResponseObject;
import org.curewallet.lib.api.result.ValidateAddressResult;
import org.curewallet.lib.jsonrpc.JsonRPCClient;
import org.curewallet.lib.jsonrpc.JsonRPCv1RequestObject;

public class ValidateAddressImpl
extends AbstractCoinAPI
implements ValidateAddress {
    protected static final String METHOD = "validateaddress";

    @Override
    public ValidateAddressResult call(JsonRPCClient jsonRPCClient, String address) throws CoinAPIException {
        try {
            if (jsonRPCClient == null) {
                throw new NullPointerException("jsonRPCClient is null.");
            }
            if (address == null || address.length() == 0) {
                throw new NullPointerException("address is null or empty.");
            }
            JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
            requestObject.setMethod(METHOD);
            requestObject.setParams(new Object[]{address});
            return jsonRPCClient.call(requestObject, ValidateAddressResponseObject.class).getResultObject();
        }
        catch (Exception e) {
            throw new CoinAPIException("Error: " + e.getMessage(), e);
        }
    }
}

