/*
 * Decompiled with CFR 0.152.
 */
package org.curewallet.lib.api.impl;

import org.curewallet.lib.api.AbstractCoinAPI;
import org.curewallet.lib.api.CoinAPIException;
import org.curewallet.lib.api.WalletPassphrase;
import org.curewallet.lib.api.response.WalletPassphraseResponseObject;
import org.curewallet.lib.api.result.WalletPassphraseResult;
import org.curewallet.lib.jsonrpc.JsonRPCClient;
import org.curewallet.lib.jsonrpc.JsonRPCv1RequestObject;

public class WalletPassphraseImpl
extends AbstractCoinAPI
implements WalletPassphrase {
    protected static final String METHOD = "walletpassphrase";

    @Override
    public WalletPassphraseResult call(JsonRPCClient jsonRPCClient, String passphrase, Long timeout) throws CoinAPIException {
        try {
            if (jsonRPCClient == null) {
                throw new NullPointerException("jsonRPCClient is null.");
            }
            if (passphrase == null) {
                throw new NullPointerException("passphrase is null.");
            }
            if (timeout == null) {
                throw new NullPointerException("timeout is null.");
            }
            JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
            requestObject.setMethod(METHOD);
            requestObject.setParams(new Object[]{passphrase, timeout});
            return jsonRPCClient.call(requestObject, WalletPassphraseResponseObject.class).getResultObject();
        }
        catch (Exception e) {
            throw new CoinAPIException("Error: " + e.getMessage(), e);
        }
    }

    @Override
    public WalletPassphraseResult call(JsonRPCClient jsonRPCClient, String passphrase, Integer timeout) throws CoinAPIException {
        return this.call(jsonRPCClient, passphrase, new Long(timeout.intValue()));
    }
}

