/*
 * Decompiled with CFR 0.152.
 */
package org.curewallet.nagesen;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.curewallet.nagesen.ececuter.Executer;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static Logger log = LoggerFactory.getLogger(Main.class);
    private static final String OPTION_DICON = "d";
    private static final String OPTION_MAX = "m";
    private static final String OPTION_INTERVAL = "i";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addOption(OPTION_DICON, "dicon", true, "Dicon file class path.");
        options.addOption(OPTION_MAX, "max", true, "Max count.");
        options.addOption(OPTION_INTERVAL, "interval", true, "Execution time interval(millisecond).");
        BasicParser parser = new BasicParser();
        S2Container container = null;
        try {
            CommandLine cl = parser.parse(options, args);
            String dicon = cl.getOptionValue(OPTION_DICON);
            if (dicon == null) {
                log.error("Please specify the dicon file.");
                System.exit(-1);
            }
            int maxcount = 10;
            String max = cl.getOptionValue(OPTION_MAX);
            if (max != null) {
                try {
                    maxcount = Integer.parseInt(max);
                }
                catch (NumberFormatException e1) {
                    System.exit(-1);
                }
            }
            int timeIntervalMillis = 30000;
            String interval = cl.getOptionValue(OPTION_INTERVAL);
            if (interval != null) {
                try {
                    timeIntervalMillis = Integer.parseInt(interval);
                }
                catch (NumberFormatException e1) {
                    System.exit(-1);
                }
            }
            container = S2ContainerFactory.create((String)dicon);
            Executer executer = (Executer)container.getComponent(Executer.class);
            executer.execute(maxcount, timeIntervalMillis);
        }
        catch (Exception e) {
            log.error("Error ", (Throwable)e);
        }
        finally {
            if (container != null) {
                container.destroy();
            }
        }
    }
}

