/*
 * Decompiled with CFR 0.152.
 */
package org.curewallet.nagesen.ececuter;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.curewallet.lib.api.CoinAPIException;
import org.curewallet.lib.api.SendFrom;
import org.curewallet.lib.api.SendToAddress;
import org.curewallet.lib.api.ValidateAddress;
import org.curewallet.lib.api.WalletLock;
import org.curewallet.lib.api.WalletPassphrase;
import org.curewallet.lib.jsonrpc.JsonRPCClient;
import org.curewallet.lib.jsonrpc.JsonRPCException;
import org.curewallet.nagesen.AddressData;
import org.curewallet.nagesen.NagesenException;
import org.curewallet.nagesen.amount.Amount;
import org.curewallet.nagesen.ececuter.Executer;
import org.curewallet.nagesen.log.SendLog;
import org.curewallet.nagesen.validator.message.MessageValidator;
import org.curewallet.nagesen.validator.unique.UniqueValidator;
import org.curewallet.nagesen.wallet.WalletInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExecuter
implements Executer {
    private static Logger log = LoggerFactory.getLogger(AbstractExecuter.class);
    private UniqueValidator uniqueValidator = null;
    private MessageValidator messageValidator = null;
    private Amount amount = null;
    private WalletPassphrase walletPassphrase = null;
    private WalletLock walletLock = null;
    private SendFrom sendFrom = null;
    private SendToAddress sendToAddress = null;
    private ValidateAddress validateAddress = null;
    private WalletInfo walletInfo = null;
    private JsonRPCClient jsonRPCClient = null;

    @Override
    public int execute(int maxCount, long timeIntervalMillis) throws NagesenException {
        try {
            List<AddressData> dataList;
            ArrayList<AddressData> dataList2 = new ArrayList<AddressData>();
            boolean owari = false;
            while ((dataList = this.getData()) != null) {
                for (AddressData data : dataList) {
                    AddressData data2 = new AddressData();
                    BeanUtils.copyProperties((Object)data2, (Object)data);
                    JsonRPCClient jsonRPCClient = this.getJsonRPCClient();
                    if (!this.validateAddress(jsonRPCClient, data2.getAddress()) || !this.getMessageValidator().validate(data2.getMessage()) || !this.getUniqueValidator().validate(dataList2, data2)) continue;
                    log.debug("Send candidate: " + data2.getCoin() + " " + data2.getAddress());
                    data2.setAmount(this.getAmount().calc(data2));
                    try {
                        this.sendFrom(jsonRPCClient, data2);
                        SendLog.log(data2);
                    }
                    catch (CoinAPIException e) {
                        log.error("Send error " + data2.getAddress(), (Throwable)e);
                    }
                    dataList2.add(data2);
                    if (dataList2.size() >= maxCount) {
                        owari = true;
                        break;
                    }
                    if (this.isContinue(data2)) continue;
                    owari = true;
                    break;
                }
                if (owari) {
                    break;
                }
                try {
                    Thread.sleep(timeIntervalMillis);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (Exception e) {
            if (e instanceof NagesenException) {
                throw (NagesenException)((Object)e);
            }
            throw new NagesenException(e);
        }
        finally {
            if (this.getJsonRPCClient() != null) {
                try {
                    this.getJsonRPCClient().close();
                }
                catch (JsonRPCException e) {
                    log.error("JsonRPCClient close failed.", (Throwable)e);
                }
            }
        }
        return 0;
    }

    protected boolean validateAddress(JsonRPCClient jsonRPCClient, String address) {
        try {
            return this.getValidateAddress().call(jsonRPCClient, address).getIsvalid();
        }
        catch (Exception e) {
            log.error("ValidateAddress error " + address, (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendFrom(JsonRPCClient jsonRPCClient, AddressData data) throws CoinAPIException {
        try {
            if (!StringUtils.isEmpty((CharSequence)this.getWalletInfo().getPassphrase())) {
                this.getWalletPassphrase().call(jsonRPCClient, this.getWalletInfo().getPassphrase(), Integer.valueOf(20));
            }
            if (StringUtils.isEmpty((CharSequence)this.getWalletInfo().getFromAccount())) {
                this.getSendToAddress().call(jsonRPCClient, data.getAddress(), data.getAmount());
            } else {
                this.getSendFrom().call(jsonRPCClient, this.getWalletInfo().getFromAccount(), data.getAddress(), data.getAmount());
            }
            data.setTimestamp(Calendar.getInstance());
        }
        finally {
            if (!StringUtils.isEmpty((CharSequence)this.getWalletInfo().getPassphrase())) {
                try {
                    this.getWalletLock().call(jsonRPCClient);
                }
                catch (CoinAPIException e) {
                    log.error("WalletLock error " + data.getAddress(), (Throwable)e);
                }
            }
        }
    }

    protected abstract List<AddressData> getData() throws NagesenException;

    protected abstract boolean isContinue(AddressData var1) throws NagesenException;

    public UniqueValidator getUniqueValidator() {
        return this.uniqueValidator;
    }

    public void setUniqueValidator(UniqueValidator uniqueValidator) {
        this.uniqueValidator = uniqueValidator;
    }

    public MessageValidator getMessageValidator() {
        return this.messageValidator;
    }

    public void setMessageValidator(MessageValidator messageValidator) {
        this.messageValidator = messageValidator;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public WalletPassphrase getWalletPassphrase() {
        return this.walletPassphrase;
    }

    public void setWalletPassphrase(WalletPassphrase walletPassphrase) {
        this.walletPassphrase = walletPassphrase;
    }

    public WalletLock getWalletLock() {
        return this.walletLock;
    }

    public void setWalletLock(WalletLock walletLock) {
        this.walletLock = walletLock;
    }

    public SendFrom getSendFrom() {
        return this.sendFrom;
    }

    public void setSendFrom(SendFrom sendFrom) {
        this.sendFrom = sendFrom;
    }

    public WalletInfo getWalletInfo() {
        return this.walletInfo;
    }

    public void setWalletInfo(WalletInfo walletInfo) {
        this.walletInfo = walletInfo;
    }

    public ValidateAddress getValidateAddress() {
        return this.validateAddress;
    }

    public void setValidateAddress(ValidateAddress validateAddress) {
        this.validateAddress = validateAddress;
    }

    public SendToAddress getSendToAddress() {
        return this.sendToAddress;
    }

    public void setSendToAddress(SendToAddress sendToAddress) {
        this.sendToAddress = sendToAddress;
    }

    public JsonRPCClient getJsonRPCClient() {
        return this.jsonRPCClient;
    }

    public void setJsonRPCClient(JsonRPCClient jsonRPCClient) {
        this.jsonRPCClient = jsonRPCClient;
    }
}

