/*
 * Version.java
 *
 * Copyright 2014 the curewallet.org.
 * http://www.curewallet.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */


import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

/**
 * アプリケーション情報を標準出力するメインクラス。
 * 
 * @version 1.0
 * @author Nezumi Kozo
 * @since 1.0
 */
public class Version {

    public static void main(String[] args) throws IOException {
        System.out.println("Apulication informations.");
        System.out.println("Name       : " + NAME);
        System.out.println("Version    : " + VERSION);
        System.out.println("Author     : " + AUTHOR);
        System.out.println("Web-Site   : " + WEB_SITE);
        System.out.println("JVM-Target : " + JVM_TARGET);
    }

    // informations.
    public static final String NAME;
    public static final String VERSION;
    public static final String AUTHOR;
    public static final String WEB_SITE;
    public static final String JVM_TARGET;

    static {
        JarFile jar = null;
        try {
            jar = new JarFile(System.getProperty("java.class.path"));
            Attributes attributes = jar.getManifest().getMainAttributes();
            NAME = attributes.getValue("Extension-Name");
            VERSION = attributes.getValue("Signature-Version");
            AUTHOR = attributes.getValue("Author");
            WEB_SITE = attributes.getValue("Implementation-URL");
            JVM_TARGET = attributes.getValue("X-Compile-Target-JDK");

        } catch (Exception e) {
            throw new RuntimeException("Cannot read a Library information.", e);

        } finally {
        	try {
        		jar.close();
        	} catch (Exception e) {
        	}
        }
    }
	
}
