/*
 * SendLog.java
 *
 * Copyright 2014 the curewallet.org.
 * http://www.curewallet.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.curewallet.nagesen.log;

import java.text.SimpleDateFormat;

import org.curewallet.nagesen.AddressData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * 
 * @author Nezumi Kozo
 * @since 1.0
 */
public class SendLog {

//	private static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(SendLog.class);	
	private static Logger log = LoggerFactory.getLogger(SendLog.class);

	private static SimpleDateFormat format;
	
	static {
		format = new SimpleDateFormat("yyyyMMddHHmmSS");
	}

	public static void log(AddressData data) {
		if (data.getTimestamp() == null) {
			log.info(data.getCoin() + " " + data.getAddress() + " " + data.getAmount() + " " + null);
		} else {
			log.info(data.getCoin() + " " + data.getAddress() + " " + data.getAmount() + " " + format.format(data.getTimestamp().getTime()));
		}
	}
	
}
