/*
 * GetNichDataImpl.java
 *
 * Copyright 2014 the curewallet.org.
 * http://www.curewallet.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.curewallet.nagesen.nich;

import java.io.BufferedReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.FilenameUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.curewallet.nagesen.NagesenException;

/**
 * 
 * 
 * @author Nezumi Kozo
 * @since 
 */
public class GetNichDataImpl implements GetNichData{

	private static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(GetNichDataImpl.class);	
//	private static Logger log = LoggerFactory.getLogger(GetNichDataImpl.class);

	/**
	 * 
	 * @since 
	 */
	public GetNichDataImpl() {
	}

	public GetNichDataResult get(String url, String modifiedSince, long range) throws NagesenException {

		try {
			//DATのURLを取得します
			URL urlObj = new URL(url);
			String datUrl = null;
			if ("dat".equals(FilenameUtils.getExtension(urlObj.getPath()))) {
				datUrl = url;
			} else {
				String[] urlTokens = urlObj.getPath().split("/");
				datUrl = "http://" + urlObj.getHost() + "/" + urlTokens[3] + "/dat/" + urlTokens[4] + ".dat";
			}

			RequestConfig requestConfig = RequestConfig.custom()
					.setConnectTimeout(getConnectionTimeout())
					.setSocketTimeout(getSockerTimeout()).build();

			List<Header> headers = new ArrayList<Header>();
			headers.add(new BasicHeader("User-Agent", getUserAgent()));

			if (modifiedSince != null) {
				headers.add(new BasicHeader(HEADER_IF_MODIFIED_SINCE, modifiedSince));
			}
			if (range > 0) {
				headers.add(new BasicHeader("Accept-Encoding", "identify"));
				headers.add(new BasicHeader(HEADER_RANGE, "bytes=" + range + "-"));
			} else {
				headers.add(new BasicHeader("Accept-Encoding", "gzip"));
			}
			log.debug("Request info: If-Modified-Since=" + modifiedSince + ", Range=" + range);

			HttpClient httpClient = HttpClientBuilder.create()
					.setDefaultRequestConfig(requestConfig)
					.setDefaultHeaders(headers).build();

			HttpGet httpGet = new HttpGet(datUrl);
			HttpResponse response = httpClient.execute(httpGet);

			// データ取得
			GetNichDataResult result = new GetNichDataResult();
			int statusCode = response.getStatusLine().getStatusCode();
			result.setStatusCode(statusCode);
			if (statusCode == STATUS_FOUND || statusCode == STATUS_MODIFIED) {

				String body = EntityUtils.toString(response.getEntity(),CHARSET);

				result.setRange(body.getBytes(CHARSET).length);
				result.setLasyModified(response.getHeaders(HEADER_LAST_MODIFIED)[0].getValue());
				log.info("Response info: status-code=" + result.getStatusCode() + ", Last-Modified=" + result.getLasyModified() + ", byte-size=" + result.getRange());

				BufferedReader br = new BufferedReader(new StringReader(body));
				String line = null;
				List<NichData> nichDataList = new ArrayList<NichData>();
				while ((line = br.readLine()) != null) {
					try {
						log.debug(line);
						String[] tokens = line.split(DELIMITER);
						NichData data = new NichData();
						data.setName(tokens[0]);
						data.setMail(tokens[1]);
						data.setTimestamp(tokens[2]);
						data.setMessage(tokens[3]);
						nichDataList.add(data);
					} catch (Exception e) {
						log.error("Error line: " + line);
						throw e;
					}
				}

				result.setNichDataList(nichDataList);
			} else {
				log.info("Response info: status-code=" + result.getStatusCode());
			}
			return result;

		} catch (Exception e) {
			throw new NagesenException(e);
		}
		
	}

	private int sockerTimeout = 0;
	private int connectionTimeout = 0;
	private String userAgent = null;


	/**
	 * @return sockerTimeout
	 * @since 1.0
	 */
	public int getSockerTimeout() {
		return sockerTimeout;
	}

	/**
	 * @param sockerTimeout セットする sockerTimeout
	 * @since 1.0
	 */
	public void setSockerTimeout(int sockerTimeout) {
		this.sockerTimeout = sockerTimeout;
	}

	/**
	 * @return connectionTimeout
	 * @since 1.0
	 */
	public int getConnectionTimeout() {
		return connectionTimeout;
	}

	/**
	 * @param connectionTimeout セットする connectionTimeout
	 * @since 1.0
	 */
	public void setConnectionTimeout(int connectionTimeout) {
		this.connectionTimeout = connectionTimeout;
	}

	/**
	 * @return userAgent
	 * @since 1.0
	 */
	public String getUserAgent() {
		return userAgent;
	}

	/**
	 * @param userAgent セットする userAgent
	 * @since 1.0
	 */
	public void setUserAgent(String userAgent) {
		this.userAgent = userAgent;
	}
	
}
