/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal.portlets.util.poll;

/**
Groups answers together so that you can run queries on them.

@author <A HREF="mailto:burton@apache.org">Kevin A. Burton</A>
@version $Id: AnswerGroup.java,v 1.3 2001/03/07 07:12:37 taylor Exp $ 
*/
public class AnswerGroup {
    
    private Answer[] answers = new Answer[0];
    
    /**
    Construct a group of answers with the given answer.

    @author <A HREF="mailto:burton@apache.org">Kevin A. Burton</A>
    @version $Id: AnswerGroup.java,v 1.3 2001/03/07 07:12:37 taylor Exp $ 
    */
    public AnswerGroup( Answer[] answers ) {
        this.answers = answers;
    }
    
    /**
    Get the answer that is currently the most popular (has the most votes).

    @author <A HREF="mailto:burton@apache.org">Kevin A. Burton</A>
    @version $Id: AnswerGroup.java,v 1.3 2001/03/07 07:12:37 taylor Exp $ 
    */
    public Answer getTopAnswer() {
        
        Answer top = null;
        
        for ( int i = 0; i < answers.length; ++i ) {
            
            
            if ( top == null ||
                 this.answers[i].getVoteCount() > top.getVoteCount() ) {

                top = this.answers[i];
                continue;

            }
            
        }
        
        return top;
        
    }
    
    /**
    Given an ID get an answer.

    @author <A HREF="mailto:burton@apache.org">Kevin A. Burton</A>
    @version $Id: AnswerGroup.java,v 1.3 2001/03/07 07:12:37 taylor Exp $ 
    */
    public Answer getAnswer( int id ) {

        for ( int i = 0; i < answers.length; ++i ) {
        
            if ( answers[i].getID() == id ) {
                return answers[i];
            }
        }
        
        return null;
    }
    
    /**
    Get all the answers in the answer group

    @author <A HREF="mailto:burton@apache.org">Kevin A. Burton</A>
    @version $Id: AnswerGroup.java,v 1.3 2001/03/07 07:12:37 taylor Exp $ 
    */
    public Answer[] getAnswers() {
        return this.answers;
    }
    
    /**
    Given an answer get the percentage of people that have voted for this.

    @author <A HREF="mailto:burton@apache.org">Kevin A. Burton</A>
    @version $Id: AnswerGroup.java,v 1.3 2001/03/07 07:12:37 taylor Exp $ 
    */
    public int getPercentage( Answer answer ) {
        
        int total = this.getTotal();
        int votes = answer.getVoteCount();
        
        if ( total == 0 ||
             votes == 0 ) {

            return 0;
        }
        
        float percentage = ((float) votes / total * 100);
        
        return (int)percentage;
        
    }
    
    /**
    Get the total of all the vote.

    @author <A HREF="mailto:burton@apache.org">Kevin A. Burton</A>
    @version $Id: AnswerGroup.java,v 1.3 2001/03/07 07:12:37 taylor Exp $ 
    */
    public int getTotal() {
        
        int total = 0;

        for ( int i = 0; i < answers.length; ++i ) {
            total += answers[i].getVoteCount();
        }
        
        return total;
    }
    
}
