/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portlet;

import java.util.Enumeration;

/**
 ** The <CODE>Client</CODE> interface represents the client device that
 ** the user connects to the portal with. It defines defines methods to
 ** obtain information about clients, e.g. browsers running on PCs, WAP
 ** phones, PDAs or on voice gateways.
 **
 ** <P>
 ** <I>
 ** This class may need to be reviewed once the picture on CC/PP is
 ** much clearer.
 ** </I>
 **
 ** @author   <A HREF="mailto:tboehme@us.ibm.com">Thomas F. Boehme</A>
 **/

public interface Client
{
    /**
     ** Returns the name of the manufacturer of this client. If the
     ** name does not exist
     **
     ** @return   the manufacturer
     **/

    public String getManufacturer ();

    /**
     ** Returns the name of the model of this client.
     **
     ** @return   the model
     **/

    public String getModel ();

    /**
     ** Returns the version of the model of this client.
     **
     ** @return   the version
     **/

    public String getVersion ();

    /**
     ** Returns the exact user agent that this client uses
     ** to connect to the portal.
     **
     ** @return   the user agent
     **/

    public String getUserAgent ();

    /**
     ** Returns whether this client has the given capability. If the
     ** portal does not know enough about the client, it has to be
     ** on the safe side and return <CODE>false</CODE>.
     **
     ** @return   <CODE>true</CODE> if the client has the given
     **                             capability, <BR>
     **           <CODE>false</CODE> otherwise
     **
     ** @see   #isCapableOf(Capability[])
     **/

    public boolean isCapableOf (Capability capability);


    /**
     ** Returns whether this client has the given capabilities. The
     ** array of capability is tested in its entirety, ie. only if
     ** the client is capable of every single capability this methods
     ** returns <CODE>true<CODE>.
     **
     ** @return   <CODE>true</CODE> if the client has the given
     **                             capability, <BR>
     **           <CODE>false</CODE> otherwise
     **
     ** @see   #isCapableOf(Capability)
     **/

    public boolean isCapableOf (Capability [] capabilities);

    /**
     ** Returns the preferred mime-type that this client device supports.
     **
     ** @return   the mime-type
     **/

    public String getMimeType ();

    /**
     ** Returns an array of mime-types in decreasing order  of preferrence.
     **
     ** @return   an enumeration of mime-types
     **/

    public Enumeration getMimeTypes ();
}
