/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portlet;

import org.apache.jetspeed.portlet.event.MessageEvent;
import org.apache.jetspeed.portlet.event.MessageListener;

import java.io.InputStream;
import java.io.IOException;

import java.util.Date;
import java.util.Locale;
import java.util.Enumeration;

/**
 ** The <CODE>PortletSession</CODE> holds the user-specific data that
 ** the portlet needs to personalize the one global portlet instance.
 ** Together with the portlet, the portlet session constitutes the
 ** virtual instance of the portlet.
 **
 ** @see   Portlet
 **
 ** @author   <A HREF="mailto:tboehme@us.ibm.com">Thomas F. Boehme</A>
 **/

public interface PortletSession
{
    /**
     ** Returns the user object. The user object contains useful
     ** information about the user and his or her preferences.
     **
     ** @return   the user profile
     **/

    public User getUser ();

    /**
     ** Returns the point of time that this session was created. Essentially,
     ** this will also be the time when the user logged in. The time is
     ** returned as the number of milliseconds since January 1, 1970 GMT.
     **
     ** @return   the time of creation
     **/

    public long getCreationTime ();

    /**
     ** Returns the point of time that this session was last accessed. The
     ** time is returned as the number of milliseconds since
     ** January 1, 1970 GMT.
     **
     ** @return   the time of the last access
     **/

    public long getLastAccessedTime ();

    /**
     ** Associates an attribute with the given name and value
     ** with this session. If a portlet needs to communicate
     ** information to embedded servlets or JSP, this methods
     ** can used carry the information along.
     **
     ** <P>
     ** The portlet provider should take care that the
     ** the namespace of attribute names is not unnecessarily
     ** polluted. It is recommended to prefix all attributes
     ** the package and class name of the portlet that
     ** makes use of this method.
     **
     ** @param   name
     **          the attribute name
     ** @param   value
     **          the attribute value
     **/

    public void setAttribute (String name, Object value);

    /**
     ** Returns the value of the attribute with the given name,
     ** or <CODE>null</CODE> if no attribute with the given name exists.
     **
     ** @param   name
     **          the attribute name
     **
     ** @return   the attribute value
     **/

    public Object getAttribute (String name);

    /**
     ** Returns an enumeration of names of all attributes available to
     ** this session. This method returns an empty enumeration if the
     ** session has no attributes available to it.
     **
     ** @return   an enumeration of attribute names
     **/

    public Enumeration getAttributeNames ();

    /**
     ** Removes the attribute with the given name.
     **
     ** @param   name
     **          the name of attribute to be removed
     **/

    public void removeAttribute (String name);
}
