package org.apache.jetspeed.om.dbregistry;


import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;


/**
 * This class was autogenerated by Torque on:
 *
 * [Thu Jun 10 23:17:32 JST 2004]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to PortletDbEntry
 */
public abstract class BasePortletDbEntry extends BaseObject
{
    /** The Peer class */
    private static final PortletDbEntryPeer peer =
        new PortletDbEntryPeer();

      
    /** The value for the id field */
    private long id;
      
    /** The value for the name field */
    private String name;
                                                                
    /** The value for the hidden field */
    private boolean hidden=false;
      
    /** The value for the classname field */
    private String classname;
      
    /** The value for the type field */
    private String type;
                                                                
    /** The value for the application field */
    private boolean application=false;
      
    /** The value for the parentRef field */
    private long parentRef;
      
    /** The value for the uRL field */
    private String uRL;
                                                                
    /** The value for the cachedonurl field */
    private boolean cachedonurl=true;
      
    /** The value for the role field */
    private String role;
      
    /** The value for the title field */
    private String title;
      
    /** The value for the description field */
    private String description;
      
    /** The value for the image field */
    private String image;
      
    /** The value for the securityRef field */
    private String securityRef;
  
  
    /**
     * Get the Id
     * @return long
     */
    public long getId()
    {
        return id;
    }

                                              
    /**
     * Set the value of Id
     */
    public void setId(long v ) throws TorqueException
    {
    
                  if (this.id != v)
              {
            this.id = v;
            setModified(true);
        }
    
          
                                  
        // update associated PortletCategory
        if (collPortletCategorys != null )
        {
            for (int i = 0; i < collPortletCategorys.size(); i++)
            {
                ((PortletCategory)collPortletCategorys.get(i))
                        .setOwner(v);
            }
        }
                                          
        // update associated PortletParameter
        if (collPortletParameters != null )
        {
            for (int i = 0; i < collPortletParameters.size(); i++)
            {
                ((PortletParameter)collPortletParameters.get(i))
                        .setPortletId(v);
            }
        }
                                          
        // update associated PortletMediatype
        if (collPortletMediatypes != null )
        {
            for (int i = 0; i < collPortletMediatypes.size(); i++)
            {
                ((PortletMediatype)collPortletMediatypes.get(i))
                        .setId(v);
            }
        }
                      }

  
    /**
     * Get the Name
     * @return String
     */
    public String getName()
    {
        return name;
    }

                        
    /**
     * Set the value of Name
     */
    public void setName(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.name, v))
              {
            this.name = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Hidden
     * @return boolean
     */
    public boolean getHidden()
    {
        return hidden;
    }

                        
    /**
     * Set the value of Hidden
     */
    public void setHidden(boolean v ) 
    {
    
                  if (this.hidden != v)
              {
            this.hidden = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Classname
     * @return String
     */
    public String getClassname()
    {
        return classname;
    }

                        
    /**
     * Set the value of Classname
     */
    public void setClassname(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.classname, v))
              {
            this.classname = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Type
     * @return String
     */
    public String getType()
    {
        return type;
    }

                        
    /**
     * Set the value of Type
     */
    public void setType(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.type, v))
              {
            this.type = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Application
     * @return boolean
     */
    public boolean getApplication()
    {
        return application;
    }

                        
    /**
     * Set the value of Application
     */
    public void setApplication(boolean v ) 
    {
    
                  if (this.application != v)
              {
            this.application = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the ParentRef
     * @return long
     */
    public long getParentRef()
    {
        return parentRef;
    }

                        
    /**
     * Set the value of ParentRef
     */
    public void setParentRef(long v ) 
    {
    
                  if (this.parentRef != v)
              {
            this.parentRef = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the URL
     * @return String
     */
    public String getURL()
    {
        return uRL;
    }

                        
    /**
     * Set the value of URL
     */
    public void setURL(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.uRL, v))
              {
            this.uRL = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Cachedonurl
     * @return boolean
     */
    public boolean getCachedonurl()
    {
        return cachedonurl;
    }

                        
    /**
     * Set the value of Cachedonurl
     */
    public void setCachedonurl(boolean v ) 
    {
    
                  if (this.cachedonurl != v)
              {
            this.cachedonurl = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Role
     * @return String
     */
    public String getRole()
    {
        return role;
    }

                        
    /**
     * Set the value of Role
     */
    public void setRole(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.role, v))
              {
            this.role = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Title
     * @return String
     */
    public String getTitle()
    {
        return title;
    }

                        
    /**
     * Set the value of Title
     */
    public void setTitle(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.title, v))
              {
            this.title = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Description
     * @return String
     */
    public String getDescription()
    {
        return description;
    }

                        
    /**
     * Set the value of Description
     */
    public void setDescription(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.description, v))
              {
            this.description = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the Image
     * @return String
     */
    public String getImage()
    {
        return image;
    }

                        
    /**
     * Set the value of Image
     */
    public void setImage(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.image, v))
              {
            this.image = v;
            setModified(true);
        }
    
          
              }

  
    /**
     * Get the SecurityRef
     * @return String
     */
    public String getSecurityRef()
    {
        return securityRef;
    }

                        
    /**
     * Set the value of SecurityRef
     */
    public void setSecurityRef(String v ) 
    {
    
                  if (!ObjectUtils.equals(this.securityRef, v))
              {
            this.securityRef = v;
            setModified(true);
        }
    
          
              }

  
         
                                
            
    /**
     * Collection to store aggregation of collPortletCategorys
     */
    protected List collPortletCategorys;

    /**
     * Temporary storage of collPortletCategorys to save a possible db hit in
     * the event objects are add to the collection, but the
     * complete collection is never requested.
     */
    protected void initPortletCategorys()
    {
        if (collPortletCategorys == null)
        {
            collPortletCategorys = new ArrayList();
        }
    }

            
    /**
     * Method called to associate a PortletCategory object to this object
     * through the PortletCategory foreign key attribute
     *
     * @param PortletCategory l
     */
    public void addPortletCategory(PortletCategory l) throws TorqueException
    {
        getPortletCategorys().add(l);
        l.setPortletDbEntry((PortletDbEntry)this);
    }

    /**
     * The criteria used to select the current contents of collPortletCategorys
     */
    private Criteria lastPortletCategorysCriteria = null;

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getPortletCategorys(new Criteria())
     */
    public List getPortletCategorys() throws TorqueException
    {
        if (collPortletCategorys == null)
        {
            collPortletCategorys = getPortletCategorys(new Criteria(10));
        }
        return collPortletCategorys;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PortletDbEntry has previously
     * been saved, it will retrieve related PortletCategorys from storage.
     * If this PortletDbEntry is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     */
    public List getPortletCategorys(Criteria criteria) throws TorqueException
    {
        if (collPortletCategorys == null)
        {
            if (isNew())
            {
               collPortletCategorys = new ArrayList();
            }
            else
            {
                      criteria.add(PortletCategoryPeer.OWNER, getId() );
                      collPortletCategorys = PortletCategoryPeer.doSelect(criteria);
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                      criteria.add(PortletCategoryPeer.OWNER, getId() );
                      if (!lastPortletCategorysCriteria.equals(criteria))
                {
                    collPortletCategorys = PortletCategoryPeer.doSelect(criteria);
                }
            }
        }
        lastPortletCategorysCriteria = criteria;

        return collPortletCategorys;
    }

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getPortletCategorys(new Criteria(),Connection)
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List getPortletCategorys(Connection con) throws TorqueException
    {
        if (collPortletCategorys == null)
        {
            collPortletCategorys = getPortletCategorys(new Criteria(10),con);
        }
        return collPortletCategorys;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PortletDbEntry has previously
     * been saved, it will retrieve related PortletCategorys from storage.
     * If this PortletDbEntry is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List getPortletCategorys(Criteria criteria,Connection con) throws TorqueException
    {
        if (collPortletCategorys == null)
        {
            if (isNew())
            {
               collPortletCategorys = new ArrayList();
            }
            else
            {
                       criteria.add(PortletCategoryPeer.OWNER, getId() );
                       collPortletCategorys = PortletCategoryPeer.doSelect(criteria,con);
             }
         }
         else
         {
             // criteria has no effect for a new object
             if (!isNew())
             {
                 // the following code is to determine if a new query is
                 // called for.  If the criteria is the same as the last
                 // one, just return the collection.
                     criteria.add(PortletCategoryPeer.OWNER, getId() );
                     if (!lastPortletCategorysCriteria.equals(criteria))
                 {
                     collPortletCategorys = PortletCategoryPeer.doSelect(criteria,con);
                 }
             }
         }
         lastPortletCategorysCriteria = criteria;

         return collPortletCategorys;
     }

                  

              
                    
                              
                                
                                                              
                                        
                    
                    
          
    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PortletDbEntry is new, it will return
     * an empty collection; or if this PortletDbEntry has previously
     * been saved, it will retrieve related PortletCategorys from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PortletDbEntry.
     */
    protected List getPortletCategorysJoinPortletDbEntry(Criteria criteria)
        throws TorqueException
    {
        if (collPortletCategorys == null)
        {
            if (isNew())
            {
               collPortletCategorys = new ArrayList();
            }
            else
            {
                            criteria.add(PortletCategoryPeer.OWNER, getId() );
                            collPortletCategorys = PortletCategoryPeer.doSelectJoinPortletDbEntry(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
            boolean newCriteria = true;
                            criteria.add(PortletCategoryPeer.OWNER, getId() );
                        if (!lastPortletCategorysCriteria.equals(criteria))
            {
                collPortletCategorys = PortletCategoryPeer.doSelectJoinPortletDbEntry(criteria);
            }
        }
        lastPortletCategorysCriteria = criteria;

        return collPortletCategorys;
    }
                            


                          
            
    /**
     * Collection to store aggregation of collPortletParameters
     */
    protected List collPortletParameters;

    /**
     * Temporary storage of collPortletParameters to save a possible db hit in
     * the event objects are add to the collection, but the
     * complete collection is never requested.
     */
    protected void initPortletParameters()
    {
        if (collPortletParameters == null)
        {
            collPortletParameters = new ArrayList();
        }
    }

            
    /**
     * Method called to associate a PortletParameter object to this object
     * through the PortletParameter foreign key attribute
     *
     * @param PortletParameter l
     */
    public void addPortletParameter(PortletParameter l) throws TorqueException
    {
        getPortletParameters().add(l);
        l.setPortletDbEntry((PortletDbEntry)this);
    }

    /**
     * The criteria used to select the current contents of collPortletParameters
     */
    private Criteria lastPortletParametersCriteria = null;

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getPortletParameters(new Criteria())
     */
    public List getPortletParameters() throws TorqueException
    {
        if (collPortletParameters == null)
        {
            collPortletParameters = getPortletParameters(new Criteria(10));
        }
        return collPortletParameters;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PortletDbEntry has previously
     * been saved, it will retrieve related PortletParameters from storage.
     * If this PortletDbEntry is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     */
    public List getPortletParameters(Criteria criteria) throws TorqueException
    {
        if (collPortletParameters == null)
        {
            if (isNew())
            {
               collPortletParameters = new ArrayList();
            }
            else
            {
                      criteria.add(PortletParameterPeer.PORTLET_ID, getId() );
                      collPortletParameters = PortletParameterPeer.doSelect(criteria);
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                      criteria.add(PortletParameterPeer.PORTLET_ID, getId() );
                      if (!lastPortletParametersCriteria.equals(criteria))
                {
                    collPortletParameters = PortletParameterPeer.doSelect(criteria);
                }
            }
        }
        lastPortletParametersCriteria = criteria;

        return collPortletParameters;
    }

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getPortletParameters(new Criteria(),Connection)
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List getPortletParameters(Connection con) throws TorqueException
    {
        if (collPortletParameters == null)
        {
            collPortletParameters = getPortletParameters(new Criteria(10),con);
        }
        return collPortletParameters;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PortletDbEntry has previously
     * been saved, it will retrieve related PortletParameters from storage.
     * If this PortletDbEntry is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List getPortletParameters(Criteria criteria,Connection con) throws TorqueException
    {
        if (collPortletParameters == null)
        {
            if (isNew())
            {
               collPortletParameters = new ArrayList();
            }
            else
            {
                       criteria.add(PortletParameterPeer.PORTLET_ID, getId() );
                       collPortletParameters = PortletParameterPeer.doSelect(criteria,con);
             }
         }
         else
         {
             // criteria has no effect for a new object
             if (!isNew())
             {
                 // the following code is to determine if a new query is
                 // called for.  If the criteria is the same as the last
                 // one, just return the collection.
                     criteria.add(PortletParameterPeer.PORTLET_ID, getId() );
                     if (!lastPortletParametersCriteria.equals(criteria))
                 {
                     collPortletParameters = PortletParameterPeer.doSelect(criteria,con);
                 }
             }
         }
         lastPortletParametersCriteria = criteria;

         return collPortletParameters;
     }

                  

              
                    
                              
                                
                                                              
                                        
                    
                    
          
    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PortletDbEntry is new, it will return
     * an empty collection; or if this PortletDbEntry has previously
     * been saved, it will retrieve related PortletParameters from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PortletDbEntry.
     */
    protected List getPortletParametersJoinPortletDbEntry(Criteria criteria)
        throws TorqueException
    {
        if (collPortletParameters == null)
        {
            if (isNew())
            {
               collPortletParameters = new ArrayList();
            }
            else
            {
                            criteria.add(PortletParameterPeer.PORTLET_ID, getId() );
                            collPortletParameters = PortletParameterPeer.doSelectJoinPortletDbEntry(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
            boolean newCriteria = true;
                            criteria.add(PortletParameterPeer.PORTLET_ID, getId() );
                        if (!lastPortletParametersCriteria.equals(criteria))
            {
                collPortletParameters = PortletParameterPeer.doSelectJoinPortletDbEntry(criteria);
            }
        }
        lastPortletParametersCriteria = criteria;

        return collPortletParameters;
    }
                            


                          
            
    /**
     * Collection to store aggregation of collPortletMediatypes
     */
    protected List collPortletMediatypes;

    /**
     * Temporary storage of collPortletMediatypes to save a possible db hit in
     * the event objects are add to the collection, but the
     * complete collection is never requested.
     */
    protected void initPortletMediatypes()
    {
        if (collPortletMediatypes == null)
        {
            collPortletMediatypes = new ArrayList();
        }
    }

            
    /**
     * Method called to associate a PortletMediatype object to this object
     * through the PortletMediatype foreign key attribute
     *
     * @param PortletMediatype l
     */
    public void addPortletMediatype(PortletMediatype l) throws TorqueException
    {
        getPortletMediatypes().add(l);
        l.setPortletDbEntry((PortletDbEntry)this);
    }

    /**
     * The criteria used to select the current contents of collPortletMediatypes
     */
    private Criteria lastPortletMediatypesCriteria = null;

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getPortletMediatypes(new Criteria())
     */
    public List getPortletMediatypes() throws TorqueException
    {
        if (collPortletMediatypes == null)
        {
            collPortletMediatypes = getPortletMediatypes(new Criteria(10));
        }
        return collPortletMediatypes;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PortletDbEntry has previously
     * been saved, it will retrieve related PortletMediatypes from storage.
     * If this PortletDbEntry is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     */
    public List getPortletMediatypes(Criteria criteria) throws TorqueException
    {
        if (collPortletMediatypes == null)
        {
            if (isNew())
            {
               collPortletMediatypes = new ArrayList();
            }
            else
            {
                      criteria.add(PortletMediatypePeer.ID, getId() );
                      collPortletMediatypes = PortletMediatypePeer.doSelect(criteria);
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                      criteria.add(PortletMediatypePeer.ID, getId() );
                      if (!lastPortletMediatypesCriteria.equals(criteria))
                {
                    collPortletMediatypes = PortletMediatypePeer.doSelect(criteria);
                }
            }
        }
        lastPortletMediatypesCriteria = criteria;

        return collPortletMediatypes;
    }

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getPortletMediatypes(new Criteria(),Connection)
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List getPortletMediatypes(Connection con) throws TorqueException
    {
        if (collPortletMediatypes == null)
        {
            collPortletMediatypes = getPortletMediatypes(new Criteria(10),con);
        }
        return collPortletMediatypes;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PortletDbEntry has previously
     * been saved, it will retrieve related PortletMediatypes from storage.
     * If this PortletDbEntry is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List getPortletMediatypes(Criteria criteria,Connection con) throws TorqueException
    {
        if (collPortletMediatypes == null)
        {
            if (isNew())
            {
               collPortletMediatypes = new ArrayList();
            }
            else
            {
                       criteria.add(PortletMediatypePeer.ID, getId() );
                       collPortletMediatypes = PortletMediatypePeer.doSelect(criteria,con);
             }
         }
         else
         {
             // criteria has no effect for a new object
             if (!isNew())
             {
                 // the following code is to determine if a new query is
                 // called for.  If the criteria is the same as the last
                 // one, just return the collection.
                     criteria.add(PortletMediatypePeer.ID, getId() );
                     if (!lastPortletMediatypesCriteria.equals(criteria))
                 {
                     collPortletMediatypes = PortletMediatypePeer.doSelect(criteria,con);
                 }
             }
         }
         lastPortletMediatypesCriteria = criteria;

         return collPortletMediatypes;
     }

                        

              
                    
                              
                                
                                                              
                                        
                    
                    
          
    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PortletDbEntry is new, it will return
     * an empty collection; or if this PortletDbEntry has previously
     * been saved, it will retrieve related PortletMediatypes from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PortletDbEntry.
     */
    protected List getPortletMediatypesJoinPortletDbEntry(Criteria criteria)
        throws TorqueException
    {
        if (collPortletMediatypes == null)
        {
            if (isNew())
            {
               collPortletMediatypes = new ArrayList();
            }
            else
            {
                            criteria.add(PortletMediatypePeer.ID, getId() );
                            collPortletMediatypes = PortletMediatypePeer.doSelectJoinPortletDbEntry(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
            boolean newCriteria = true;
                            criteria.add(PortletMediatypePeer.ID, getId() );
                        if (!lastPortletMediatypesCriteria.equals(criteria))
            {
                collPortletMediatypes = PortletMediatypePeer.doSelectJoinPortletDbEntry(criteria);
            }
        }
        lastPortletMediatypesCriteria = criteria;

        return collPortletMediatypes;
    }
                  
                    
                    
                                
                                                              
                                        
                    
                    
          
    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this PortletDbEntry is new, it will return
     * an empty collection; or if this PortletDbEntry has previously
     * been saved, it will retrieve related PortletMediatypes from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in PortletDbEntry.
     */
    protected List getPortletMediatypesJoinMediatype(Criteria criteria)
        throws TorqueException
    {
        if (collPortletMediatypes == null)
        {
            if (isNew())
            {
               collPortletMediatypes = new ArrayList();
            }
            else
            {
                            criteria.add(PortletMediatypePeer.ID, getId() );
                            collPortletMediatypes = PortletMediatypePeer.doSelectJoinMediatype(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
            boolean newCriteria = true;
                            criteria.add(PortletMediatypePeer.ID, getId() );
                        if (!lastPortletMediatypesCriteria.equals(criteria))
            {
                collPortletMediatypes = PortletMediatypePeer.doSelectJoinMediatype(criteria);
            }
        }
        lastPortletMediatypesCriteria = criteria;

        return collPortletMediatypes;
    }
                            


          
    private static List fieldNames = null;

    /**
     * Generate a list of field names.
     */
    public static synchronized List getFieldNames()
    {
        if (fieldNames == null)
        {
            fieldNames = new ArrayList();
              fieldNames.add("Id");
              fieldNames.add("Name");
              fieldNames.add("Hidden");
              fieldNames.add("Classname");
              fieldNames.add("Type");
              fieldNames.add("Application");
              fieldNames.add("ParentRef");
              fieldNames.add("URL");
              fieldNames.add("Cachedonurl");
              fieldNames.add("Role");
              fieldNames.add("Title");
              fieldNames.add("Description");
              fieldNames.add("Image");
              fieldNames.add("SecurityRef");
              fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.
     */
    public Object getByName(String name)
    {
          if (name.equals("Id"))
        {
                return new Long(getId());
            }
          if (name.equals("Name"))
        {
                return getName();
            }
          if (name.equals("Hidden"))
        {
                return new Boolean(getHidden());
            }
          if (name.equals("Classname"))
        {
                return getClassname();
            }
          if (name.equals("Type"))
        {
                return getType();
            }
          if (name.equals("Application"))
        {
                return new Boolean(getApplication());
            }
          if (name.equals("ParentRef"))
        {
                return new Long(getParentRef());
            }
          if (name.equals("URL"))
        {
                return getURL();
            }
          if (name.equals("Cachedonurl"))
        {
                return new Boolean(getCachedonurl());
            }
          if (name.equals("Role"))
        {
                return getRole();
            }
          if (name.equals("Title"))
        {
                return getTitle();
            }
          if (name.equals("Description"))
        {
                return getDescription();
            }
          if (name.equals("Image"))
        {
                return getImage();
            }
          if (name.equals("SecurityRef"))
        {
                return getSecurityRef();
            }
          return null;
    }
    
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     */
    public Object getByPeerName(String name)
    {
          if (name.equals(PortletDbEntryPeer.ID ))
        {
                return new Long(getId());
            }
          if (name.equals(PortletDbEntryPeer.NAME ))
        {
                return getName();
            }
          if (name.equals(PortletDbEntryPeer.HIDDEN ))
        {
                return new Boolean(getHidden());
            }
          if (name.equals(PortletDbEntryPeer.CLASSNAME ))
        {
                return getClassname();
            }
          if (name.equals(PortletDbEntryPeer.TYPE ))
        {
                return getType();
            }
          if (name.equals(PortletDbEntryPeer.APPLICATION ))
        {
                return new Boolean(getApplication());
            }
          if (name.equals(PortletDbEntryPeer.PARENT ))
        {
                return new Long(getParentRef());
            }
          if (name.equals(PortletDbEntryPeer.URL ))
        {
                return getURL();
            }
          if (name.equals(PortletDbEntryPeer.CACHEDONURL ))
        {
                return new Boolean(getCachedonurl());
            }
          if (name.equals(PortletDbEntryPeer.ROLE ))
        {
                return getRole();
            }
          if (name.equals(PortletDbEntryPeer.TITLE ))
        {
                return getTitle();
            }
          if (name.equals(PortletDbEntryPeer.DESCRIPTION ))
        {
                return getDescription();
            }
          if (name.equals(PortletDbEntryPeer.IMAGE ))
        {
                return getImage();
            }
          if (name.equals(PortletDbEntryPeer.SECURITY ))
        {
                return getSecurityRef();
            }
          return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     */
    public Object getByPosition(int pos)
    {
            if ( pos == 0 )
        {
                return new Long(getId());
            }
              if ( pos == 1 )
        {
                return getName();
            }
              if ( pos == 2 )
        {
                return new Boolean(getHidden());
            }
              if ( pos == 3 )
        {
                return getClassname();
            }
              if ( pos == 4 )
        {
                return getType();
            }
              if ( pos == 5 )
        {
                return new Boolean(getApplication());
            }
              if ( pos == 6 )
        {
                return new Long(getParentRef());
            }
              if ( pos == 7 )
        {
                return getURL();
            }
              if ( pos == 8 )
        {
                return new Boolean(getCachedonurl());
            }
              if ( pos == 9 )
        {
                return getRole();
            }
              if ( pos == 10 )
        {
                return getTitle();
            }
              if ( pos == 11 )
        {
                return getDescription();
            }
              if ( pos == 12 )
        {
                return getImage();
            }
              if ( pos == 13 )
        {
                return getSecurityRef();
            }
              return null;
    }
     
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save() throws Exception
    {
          save(PortletDbEntryPeer.getMapBuilder()
                .getDatabaseMap().getName());
      }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
       * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
       */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
          try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }
      }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     */
    public void save(Connection con) throws TorqueException
    {
          if (!alreadyInSave)
        {
            alreadyInSave = true;


  
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    PortletDbEntryPeer.doInsert((PortletDbEntry)this, con);
                    setNew(false);
                }
                else
                {
                    PortletDbEntryPeer.doUpdate((PortletDbEntry)this, con);
                }

                      if (isCacheOnSave())
                {
                    PortletDbEntryManager.putInstance(this);
                }
              }

                                      
                            if (collPortletCategorys != null )
            {
                for (int i = 0; i < collPortletCategorys.size(); i++)
                {
                    ((PortletCategory)collPortletCategorys.get(i)).save(con);
                }
            }
                                          
                            if (collPortletParameters != null )
            {
                for (int i = 0; i < collPortletParameters.size(); i++)
                {
                    ((PortletParameter)collPortletParameters.get(i)).save(con);
                }
            }
                                          
                            if (collPortletMediatypes != null )
            {
                for (int i = 0; i < collPortletMediatypes.size(); i++)
                {
                    ((PortletMediatype)collPortletMediatypes.get(i)).save(con);
                }
            }
                          alreadyInSave = false;
        }
      }

    /**
     * Specify whether to cache the object after saving to the db.
     * This method returns false
     */
    protected boolean isCacheOnSave()
    {
        return true;
    }

                        
      /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param ObjectKey id
     */
    public void setPrimaryKey(ObjectKey id)
        throws TorqueException {
            setId(((NumberKey)id).longValue());
        }

    /**
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) throws TorqueException
    {
            setId(Long.parseLong(key));
        }

  
    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
          return SimpleKey.keyFor(getId());
      }
 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
       * It then fills all the association collections.
       */
      public PortletDbEntry copy() throws TorqueException
    {
        PortletDbEntry copyObj = new PortletDbEntry();
            copyObj.setId(id);
          copyObj.setName(name);
          copyObj.setHidden(hidden);
          copyObj.setClassname(classname);
          copyObj.setType(type);
          copyObj.setApplication(application);
          copyObj.setParentRef(parentRef);
          copyObj.setURL(uRL);
          copyObj.setCachedonurl(cachedonurl);
          copyObj.setRole(role);
          copyObj.setTitle(title);
          copyObj.setDescription(description);
          copyObj.setImage(image);
          copyObj.setSecurityRef(securityRef);
  
                      copyObj.setId(0);
                                                                                          
                                      
                
        List v = getPortletCategorys();
        for (int i = 0; i < v.size(); i++)
        {
            PortletCategory obj = (PortletCategory) v.get(i);
            copyObj.addPortletCategory(obj.copy());
        }
                                                  
                
        v = getPortletParameters();
        for (int i = 0; i < v.size(); i++)
        {
            PortletParameter obj = (PortletParameter) v.get(i);
            copyObj.addPortletParameter(obj.copy());
        }
                                                  
                
        v = getPortletMediatypes();
        for (int i = 0; i < v.size(); i++)
        {
            PortletMediatype obj = (PortletMediatype) v.get(i);
            copyObj.addPortletMediatype(obj.copy());
        }
                            return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public PortletDbEntryPeer getPeer()
    {
        return peer;
    }
}
