/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jetspeed.services.registry;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;

// Jetspeed imports
import org.apache.jetspeed.test.JetspeedTestCase;
import org.apache.jetspeed.om.registry.base.*;

import ojb.broker.PersistenceBroker;
import ojb.broker.query.Query;
import ojb.broker.query.QueryByCriteria;
import ojb.broker.query.Criteria;

import org.apache.turbine.util.TurbineConfig;
import org.apache.turbine.util.StringUtils;

import org.apache.jetspeed.services.JetspeedDatabase;

/**
 * TestRegistryPersistence
 *
 * @author <a href="taylor@apache.org">David Sean Taylor</a>
 * @version $Id: TestRegistryPersistence.java,v 1.1 2004/04/07 22:02:42 jford Exp $
 */

public class TestRegistryPersistence extends JetspeedTestCase {    

    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestRegistryPersistence( String name ) {
        super( name );
    }
    
    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[]) {
        junit.awtui.TestRunner.main( new String[] { TestRegistryPersistence.class.getName() } );
    }
 
    public void setup() {
        System.out.println("Setup: Testing ObjectBridge");
     }
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite() {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestRegistryPersistence.class );
    }

    /**
     * 
     *
     * @throws Exception
     */

    public void testInsertUpdateDelete() throws Exception 
    {
        PersistenceBroker pm = null;
        try
        {
            pm = (PersistenceBroker) JetspeedDatabase.getPersistenceManager();

            MediaTypeTest(pm);
            SkinTest(pm);  
        }
        catch (Throwable t)
        {
            t.printStackTrace();
        }
    }

    void MediaTypeTest(PersistenceBroker pm) throws Exception
    {
        // test insert
        BaseMediaTypeEntry newEntry = new BaseMediaTypeEntry(0, "XHTML9", 0, "text.xhtml.9", 
                                                             "Some Title", "Some Description", "Some Image", "SU");

        pm.beginTransaction();
        pm.store(newEntry);
        pm.commitTransaction();

        // test update
        Criteria criteria = new Criteria();
        criteria.addEqualTo("name", "XHTML9");
        Query query = new QueryByCriteria(BaseMediaTypeEntry.class, criteria);
        BaseMediaTypeEntry entry  = (BaseMediaTypeEntry)pm.getObjectByQuery(query);
        assertTrue(entry.getName().equals("XHTML9"));           
        System.out.println("id = " + entry.getId());
        assertTrue(entry.getHidden() == false);           
        assertTrue(entry.getMimeType().equals("text.xhtml.9"));           
        assertTrue(entry.getMetaInfo().getTitle().equals("Some Title"));           
        assertTrue(entry.getDescription().equals("Some Description"));           
        assertTrue(entry.getMetaInfo().getImage().equals("Some Image"));           
        assertTrue(entry.getSecurity().getRole().equals("SU"));                     

        entry.setHidden(true);
        entry.setMimeType("text.xhtml.9.1");
        entry.getMetaInfo().setTitle("New Title");
        entry.setDescription("New Description");
        entry.getSecurity().setRole("Dumb");

        pm.beginTransaction();
        pm.store(entry);
        pm.commitTransaction();

        // delete
        pm.beginTransaction();
        BaseMediaTypeEntry entry2  = (BaseMediaTypeEntry)pm.getObjectByQuery(query);
        assertTrue(entry2.getHidden() == true);           
        assertTrue(entry2.getMimeType().equals("text.xhtml.9.1"));           
        assertTrue(entry2.getMetaInfo().getTitle().equals("New Title"));           
        assertTrue(entry2.getMetaInfo().getDescription().equals("New Description"));           
        assertTrue(entry2.getSecurity().getRole().equals("Dumb"));                     

        pm.delete(entry2);
        pm.commitTransaction();

    }

    void SkinTest(PersistenceBroker pm) throws Exception
    {
        // DST: left off here
    }

   /*
      Configuration object to run Turbine outside a servlet container
      ( uses turbine.properties )
    */
    private static TurbineConfig config = null;
    
    /*    
      Sets up TurbineConfig using the system property:
      <pre>turbine.properties</pre>
    */
    static
    {
        try
        {
           config = new TurbineConfig( "webapp", "/WEB-INF/conf/TurbineResources.properties");
           config.init();
        }
        catch (Exception e)
        {
            //fail(StringUtils.stackTrace(e));
            System.out.println(StringUtils.stackTrace(e));
        }
    }
}