/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portlet;

import java.util.Enumeration;

/**
 ** The <CODE>User</CODE> interface is an abstract view on the
 ** user-specific data. Apart from a set of pre-defined, fixed set
 ** of attributes, the interface gives access to dynamic data
 ** as well.
 **
 ** <P>
 ** To enable a portlet to access dynamic data, the naming conventions
 ** of the portlet container have to be propagated to the portlet. It
 ** is recommended to do so through the portlet configuration. For
 ** example, if the portlet wants to access an "address" attribute, it
 ** should query its configuration for the dynamic data name of the
 ** "address" attribute for this particular installation. If no such

 **
 ** <P>
 ** <I>
 ** This interface has to be properly thought through. What are the
 ** the essential attributes? Should some be fixed (ie. the essentials)
 ** or all be dynamic?
 ** </I>
 **
 ** @author   <A HREF="mailto:tboehme@us.ibm.com">Thomas F. Boehme</A>
 **/

public interface User
{
    /**
     ** Returns the user id.
     **
     ** @return   the user id
     **/

    public String getID ();

    /**
     ** Returns the given (aka first) name of the user.
     **
     ** @return   the given name
     **/

    public String getGivenName ();

    /**
     ** Returns the middle names of the user.
     **
     ** @return   the middle names
     **/

    public String getMiddleNames ();

    /**
     ** Returns the family (aka last) name of the user.
     **
     ** @return   the family name
     **/

    public String getFamilyName ();

    /**
     ** Returns the nick name of the user.
     **
     ** @return   the nick name
     **/

    public String getNickName ();

    /**
     ** Returns the point of time that this was last logged in,
     ** or <CODE>null</CODE> if this information is not available.
     ** The time is returned in number of milliseconds since
     ** January 1, 1970 GMT.
     **
     ** @return   the last login time
     **/

    public long getLastLoginTime ();

    /**
     * Returns whether the user is logged in or not.
     *
     * @return True if the user is logged in.
     */
    public boolean isLoggedIn();

}
