/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.enquete;

import java.util.ArrayList;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * ワークフローのResultDataです。 <BR>
 *
 */
public class EnqueteItemRecordData implements ALData {

  /** ITEM ID */
  private Integer item_id;
  
  /** 項目名 */
  private ALStringField itemName;

  /** 項目番号 */
  private Integer item_number;
  
  /** 状態(複数選択可不可) */
  private String status;
  
  private ALStringField choiceItem;
  
  private ArrayList choiceItemName;
  
  private Integer memberSum;
  
  private Integer answerSum;

  
  
  public void initField() {
    item_id = new Integer(item_id);
    itemName = new ALStringField();

    item_number = new Integer(item_number);
    status = new String();
    choiceItem = new ALStringField();
    choiceItemName = new ArrayList();
    memberSum = new Integer(memberSum);
    answerSum = new Integer(answerSum);
  }



  public Integer getItemId() {
    return item_id;
  }



  public void setItemId(Integer item_id) {
    this.item_id = item_id;
  }



  public ALStringField getItemName() {
    return itemName;
  }



  public void setItemName(ALStringField itemName) {
    this.itemName = itemName;
  }



  public Integer getItemNumber() {
    return item_number;
  }



  public void setItemNumber(Integer item_number) {
    this.item_number = item_number;
  }



  public String getStatus() {
    return status;
  }



  public void setStatus(String status) {
    this.status = status;
  }



  public ALStringField getChoiceItem() {
    return choiceItem;
  }



  public void setChoiceItem(ALStringField choiceItem) {
    this.choiceItem = choiceItem;
  }



  public ArrayList getChoiceItemName() {
    return choiceItemName;
  }



  public void setChoiceItemName(ArrayList choiceItemName) {
    this.choiceItemName = choiceItemName;
  }



  public Integer getMemberSum() {
    return memberSum;
  }



  public void setMemberSum(Integer memberSum) {
    this.memberSum = memberSum;
  }



  public Integer getAnswerSum() {
    return answerSum;
  }



  public void setAnswerSum(Integer answerSum) {
    this.answerSum = answerSum;
  }





}
