/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.coordinationforgooglecal;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.util.ALEipUtils;

/**
 * ワークフローのResultDataです。 <BR>
 *
 */
public class CoordinationForGoogleCalRecordData implements ALData {


  
  /** タイトル */
  private ALStringField summary;

  /** 場所 */
  private ALStringField location;
  
  /**　メモ  */
  private String description;
  
  /**　公開設定  */
  private ALStringField classification;
  
  /**　作成日  */
  private ALDateTimeField created;
  
  /**　更新日  */
  private ALDateTimeField last_modified;
  
  /**　開始時間  */
  private ALDateTimeField start_date;

  /**　終了時間  */
  private ALDateTimeField end_date;
  
  /**　繰り返しルール  */
  private ALStringField repeat_rule;
  
  /**　登録可不可チェック  */
  private ALStringField error_flag;
  
  /**　開始・終了時間チェック  */
  private ALStringField start_end_time_err;
  
  /**　作成日チェックチェック  */
  private ALStringField created_time_err;
  
  /**　更新日チェック  */
  private ALStringField last_modified_time_err;

  
  
  public void initField() {
    summary = new ALStringField();
    location = new ALStringField();
    description = new String();
    classification = new ALStringField();
    created = new ALDateTimeField("yyyy-MM-dd-HH-mm");
    last_modified = new ALDateTimeField("yyyy-MM-dd-HH-mm");
    start_date = new ALDateTimeField();
    end_date = new ALDateTimeField();
    repeat_rule = new ALStringField();
    error_flag = new ALStringField();
    start_end_time_err = new ALStringField();
    created_time_err = new ALStringField();
    last_modified_time_err = new ALStringField();

  }



  public ALStringField getStartEndTimeErr() {
    return start_end_time_err;
  }

  public void setStartEndTimeErr(ALStringField start_end_time_err) {
    this.start_end_time_err = start_end_time_err;
  }

  public ALStringField getCreatedTimeErr() {
    return created_time_err;
  }

  public void setCreatedTimeErr(ALStringField created_time_err) {
    this.created_time_err = created_time_err;
  }

  public ALStringField getLastModifiedTimeErr() {
    return last_modified_time_err;
  }

  public void setLastModifiedTimeErr(ALStringField last_modified_time_err) {
    this.last_modified_time_err = last_modified_time_err;
  }

  public ALStringField getSummary() {
    return summary;
  }

  public void setSummary(ALStringField summary) {
    this.summary = summary;
  }

  public ALStringField getLocation() {
    return location;
  }

  public void setLocation(ALStringField location) {
    this.location = location;
  }

  public String getDescription() {
    return ALEipUtils.getMessageList(description);
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public ALStringField getClassification() {
    return classification;
  }

  public void setClassification(ALStringField classification) {
    this.classification = classification;
  }

  public ALDateTimeField getCreated() {
    return created;
  }

  public void setCreated(ALDateTimeField created) {
    this.created = created;
  }

  public ALDateTimeField getLastModified() {
    return last_modified;
  }

  public void setLastModified(ALDateTimeField last_modified) {
    this.last_modified = last_modified;
  }

  public ALDateTimeField getStartDate() {
    return start_date;
  }

  public void setStartDate(ALDateTimeField start_date) {
    this.start_date = start_date;
  }

  public ALDateTimeField getEndDate() {
    return end_date;
  }

  public void setEndDate(ALDateTimeField end_date) {
    this.end_date = end_date;
  }

  public ALStringField getRepeatRule() {
    return repeat_rule;
  }

  public void setRepeatRule(ALStringField repeat_rule) {
    this.repeat_rule = repeat_rule;
  }

  public ALStringField getErrorFlag() {
    return error_flag;
  }

  public void setErrorFlag(ALStringField error_flag) {
    this.error_flag = error_flag;
  }

}
