/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

dojo.provide("aipo.coordinationforgooglecal");

dojo.require("aipo.widget.DropdownDatepicker");

aipo.coordinationforgooglecal.onLoadCoordinationForGoogleCalDialog = function(portlet_id){

  var obj = dojo.byId("name");
  if(obj){
     obj.focus();
  } 
}

aipo.coordinationforgooglecal.onReceiveMessage = function(msg){

    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        aipo.portletReload('coordinationforgooglecal');
    }
    if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
    }
    
}


aipo.coordinationforgooglecal.changeSummaryUnit = function(unit) {

  if( unit == "month" ) {
    dojo.byId('div_unit_month').style.display = "";
    dojo.byId('div_unit_day').style.display = "none";
    dojo.byId('time_change').value = "month_select"
    
  } else {
    dojo.byId('div_unit_month').style.display = "none";
    dojo.byId('div_unit_day').style.display = "";    
    dojo.byId('time_change').value = "day_select"
    
    if( dojo.byId('from') != null && dojo.byId('from').innerHTML == "" ) {
      aipo.coordinationforgooglecal.createCalendar();
    }
  }
}

aipo.coordinationforgooglecal.createCalendar = function() {

  var default_from_date = dojo.byId('default_from_date').value;
  var default_to_date = dojo.byId('default_to_date').value;

  dojo.require("aipo.widget.DropdownDatepicker");
  var from = new aipo.widget.DropdownDatepicker({ 
    name: "fromday",
    iconURL: "images/icon/icon_date.gif",
    widgetId: "acceptdatepicker",
    dateId: "from_date",
    displayCheck: "none",
    iconAlt: "FROM",
    hiddenId: "from_date",
    initValue: default_from_date,
    inputId: "input_from_date"
    }, 
    dojo.byId("from"));
  

  var to = new aipo.widget.DropdownDatepicker({ 
    name: "fromday",
    iconURL: "images/icon/icon_date.gif",
    widgetId: "acceptdatepicker",
    dateId: "to_date",
    displayCheck: "none",
    iconAlt: "TO",
    hiddenId: "to_date",
    initValue: default_to_date,
    inputId: "input_to_date"
    }, 
    dojo.byId("to"));

}