/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.extcabinet;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * 文書管理のファイルのResultDataです。 <BR>
 *
 */
public class ExtCabinetAclResultData implements ALData {

  /** ファイル ID */
  private ALNumberField id;

  /** フォルダ ID */
  private ALStringField target_id;
  
  /** フォルダ ID */
  private ALStringField target_type;
  
  /** フォルダ ID */
  private ALStringField target_name;

  /** フォルダ追加可能か */
  private boolean is_folder_creatable;
  
  /** ファイル追加可能か */
  private boolean is_file_creatable;
  
  /** 読込可能か */
  private boolean is_readable;
  
  /** 書込可能か */
  private boolean is_writable;
  
  /** 削除可能か */
  private boolean is_deletable;
  
  /** 登録日 */
  private ALStringField create_date;

  /** 更新日 */
  private ALStringField update_date;

  /**
   *
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    id = new ALNumberField();
    target_id = new ALStringField();
    target_type = new ALStringField();
    target_name = new ALStringField();
    create_date = new ALStringField();
    update_date = new ALStringField();
    is_folder_creatable = false;
    is_file_creatable = false;
    is_readable = false;
    is_writable = false;
    is_deletable = false;
  }

  public ALNumberField getId() {
    return id;
  }

  public void setId(long i) {
    id.setValue(i);
  }
  
  public ALStringField getTargetId() {
    return target_id;
  }

  public void setTargetId(String i) {
    target_id.setValue(i);
  }
  
  public ALStringField getTargetType() {
    return target_type;
  }

  public void setTargetType(String string) {
    target_type.setValue(string);
  }
  
  public ALStringField getTargetName() {
    return target_name;
  }

  public void setTargetName(String i) {
    target_name.setValue(i);
  }

  public ALStringField getCreateDate() {
    return create_date;
  }
  
  public void setCreateDate(String string) {
    create_date.setValue(string);
  }

  public void setUpdateDate(String string) {
    update_date.setValue(string);
  }
  
  public ALStringField getUpdateDate() {
    return update_date;
  }
  
  public void setFolderCreatable(boolean b) {
    this.is_folder_creatable = b;
  }

  public boolean isFolderCreatable() {
    return is_folder_creatable;
  }

  public void setFileCreatable(boolean b) {
    this.is_file_creatable = b;
  }

  public boolean isFileCreatable() {
    return is_file_creatable;
  }
  
  public void setReadable(boolean b) {
    this.is_readable = b;
  }

  public boolean isReadable() {
    return is_readable;
  }
  
  public void setWritable(boolean b) {
    this.is_writable = b;
  }
  
  public boolean isWritable() {
    return is_writable;
  }
  
  public void setDeletable(boolean b) {
    this.is_deletable = b;
  }

  public boolean isDeletable() {
    return is_deletable;
  }
  
  public boolean isFixedReadableCheckForFolder() {
    return is_folder_creatable || is_file_creatable || is_writable || is_deletable;
  }
  
  public boolean isFixedReadableCheckForFile() {
    return is_writable || is_deletable;
  }

}
