/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.modules.actions.extcabinet;

import java.util.ArrayList;
import java.util.List;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.extcabinet.ExtCabinetSelectData;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 文書管理の取り扱いに関するアクションクラスです。 <br />
 * 
 */
public class ExtCabinetAction extends ALBaseAction {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(ExtCabinetAction.class.getName());

  /**
   * 通常表示の際の処理を記述します。 <BR>
   * 
   * @param portlet
   * @param context
   * @param rundata
   * @throws Exception
   * @see org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction#buildNormalContext(org.apache.jetspeed.portal.portlets.VelocityPortlet,
   *      org.apache.velocity.context.Context, org.apache.turbine.util.RunData)
   */
  protected void buildNormalContext(VelocityPortlet portlet, Context context,
      RunData rundata) throws Exception {
    // セッション情報のクリア
    clearCabinetSession(rundata, context);

    ExtCabinetSelectData listData = new ExtCabinetSelectData();
    listData.setIsNormalContext(true);
    listData.initField();
    listData.setRowsNum(Integer.parseInt(ALEipUtils
        .getPortlet(rundata, context).getPortletConfig().getInitParameter(
            "p1a-rows")));
    if (listData.doViewList(this, rundata, context)) {
      setTemplate(rundata, "extcabinet");
    }
  }

  /**
   * 最大化表示の際の処理を記述する． <BR>
   * 
   * @param portlet
   * @param context
   * @param rundata
   */
  protected void buildMaximizedContext(VelocityPortlet portlet,
      Context context, RunData rundata) {

    // MODEを取得
    String mode = rundata.getParameters().getString(ALEipConstants.MODE);
    try {
      if (ALEipConstants.MODE_LIST.equals(mode)) {
        doExtcabinet_list(rundata, context);
      }
      if (getMode() == null) {
        doExtcabinet_list(rundata, context);
      }
    } catch (Exception ex) {
      logger.error("Exception", ex);
    }

  }

  /**
   * 文書管理の一覧を表示する． <BR>
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doExtcabinet_list(RunData rundata, Context context) throws Exception {
    ExtCabinetSelectData listData = new ExtCabinetSelectData();
    listData.initField();
    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
        .getPortlet(rundata, context).getPortletConfig().getInitParameter(
            "p1b-rows")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "extcabinet-list");
  }

  private void clearCabinetSession(RunData rundata, Context context) {
    List<String> list = new ArrayList<String>();
    list.add("entityid");
    list.add("ext_folder_id");
    list.add("ExtCabinetFileWord");
    list.add("com.aimluck.eip.extcabinet.ExtCabinetFolderSelectDatasort");
    list.add("com.aimluck.eip.extcabinet.ExtCabinetFileWordSelectDatasort");
    ALEipUtils.removeTemp(rundata, context, list);
  }
}
