﻿/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
dojo.require("aipo.widget.MemberNormalSelectList");

dojo.provide("aipo.extcabinet");

aipo.extcabinet.onLoadCabinetFileDialog = function(pid){
    var url_userlist = dojo.byId('urlUserlist'+pid).value;
    var dst_user_id = dojo.byId('urlDstUser'+pid).value;
    if(url_userlist){
        aipo.extcabinet.changeGroup(url_userlist, 'LoginUser', dst_user_id);
        //aipo.extcabinet.changeGroup(url_userlist, 'ALL', dst_user_id);  
    }   

    var obj = dojo.byId("file_title");
    if(obj){
        obj.focus();
    }

}

aipo.extcabinet.onLoadCabinetFolderDialog = function(pid){

    var url_userlist = dojo.byId('urlUserlist'+pid).value;
    var dst_user_id = dojo.byId('urlDstUser'+pid).value;
    if(url_userlist){
        aipo.extcabinet.changeGroup(url_userlist, 'LoginUser', dst_user_id);
        //aipo.extcabinet.changeGroup(url_userlist, 'ALL', dst_user_id);    
    }   

    var obj = dojo.byId("folder_name");
    if(obj){
        obj.focus();
    }
}

aipo.extcabinet.onReceiveMessage = function(msg){
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        aipo.portletReload('extcabinet');
    }
    if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
    }
}

aipo.extcabinet.onAdminRootReceiveMessage = function(msg){
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        aipo.portletReload('extcabinet_admin_root');
    }
    if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
    }
}

aipo.extcabinet.onListReceiveMessage = function(msg){
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        aipo.portletReload('extcabinet');
    }
    if (dojo.byId('listmessageDiv')) {
        dojo.byId('listmessageDiv').innerHTML = msg;
    }
}

aipo.extcabinet.onSubmitSerchButton = function(form,url,p_id){
     var exec_url = url;
     var search_params = [["sword",form.sword.value]];
     aipo.viewPage(exec_url, p_id, search_params);
}

aipo.extcabinet.viewpageByFolderId = function(url,p_id,f_id){
    url = url + '&folder_id=' + f_id;
    aipo.viewPage(url, p_id);
}

aipo.extcabinet.ajaxDeleteSubmit = function(button, url, indicator_id, portlet_id, receive) {
  if(confirm('この'+button.form._name.value+'を削除してよろしいですか？なお、フォルダに含まれるファイルやフォルダはすべて削除されます。')) {
    aimluck.io.disableForm(button.form, true);
    aimluck.io.setHiddenValue(button);
    button.form.action = url;
    aimluck.io.submit(button.form, indicator_id, portlet_id, receive);
  }
}

aipo.extcabinet.appendRow = function(){

  var groups = dojo.byId('target_group_name');
  var group_name = groups.options[groups.selectedIndex].value;
  if( group_name == "" ) {
    return;
  }
  
  var target_type = "";
  var target_name = "";
  var target_id = "";
  
  var users = dojo.byId('dest_user_id');
  var user_id = users.options[users.selectedIndex].value;
  if( user_id == "" ) {
    return;
  } 
  
  if( group_name != "LoginUser" ) {
	  //var users = dojo.byId('dest_user_id');
	  //var user_id = users.options[users.selectedIndex].value;
	  //if( user_id == "" ) {
	  //  return;
	  //} 
	  
	  if( user_id == "GROUP" ) {
	    target_type = "G";
	    target_name = groups.options[groups.selectedIndex].innerHTML;
	    target_id = groups.options[groups.selectedIndex].value;
	  } else {
	    target_type = "U";
	    target_name = users.options[users.selectedIndex].innerHTML;
	    target_id = users.options[users.selectedIndex].value;
	  }
  } else {
    if( user_id == "ALL" ) {
      target_type ="E";
      target_id ="E";
      target_name ="ユーザー全員";
    } else {
	  target_type = "U";
	  target_name = users.options[users.selectedIndex].innerHTML;
	  target_id = users.options[users.selectedIndex].value;
    }
  }
  
  var tbase = dojo.byId('base_acl').tBodies[0];
  var tbod = dojo.byId('acl_edit_table').tBodies[0];
  for (var i = 1, len = tbod.rows.length; i < len; i++) {
    var tr = tbod.rows[i];
    for (var j = 0, td; td = tr.cells[j]; j++) {
      for (var k = 0, obj; obj = td.childNodes[k]; k++){
        var name = obj.name;
        if (name) {				
          if (name.indexOf('acl[target_id][]') == 0) {
            if( target_id == obj.value ) {
              alert("既に登録済みです。");
              return;
            }
          }
        }
      }
    }
  }

  var rcopy = tbase.rows[0].cloneNode(true);
  tbod.insertBefore(rcopy, null);
	
  var new_row = tbod.rows[tbod.rows.length-1];
  new_row.cells[0].innerHTML = target_name;
  
  for (var k = 0, obj; obj = new_row.cells[new_row.cells.length-1].childNodes[k]; k++){
    var name = obj.name;
    if (name) {				
      if (name.indexOf('acl[target_id][]') == 0) {
        obj.value = target_id;
      }
      if (name.indexOf('acl[target_type][]') == 0) {
        obj.value = target_type;
      }
    }
  }
}

if (window.addEventListener) {
	window.addEventListener('click',function(e){
		window.event = e;
		window.event.srcElement = e.target;
	},true);
} 

aipo.extcabinet.deleteRow = function(){
	var bt = window.event.srcElement;
	var tr = bt.parentNode.parentNode;
	var tbod = tr.parentNode;
	tbod.deleteRow(tr.sectionRowIndex);
}

aipo.extcabinet.changeCheck = function(obj, id){

  var td = obj.parentNode;
  for (var k = 0, obj; obj = td.childNodes[k]; k++){
    var name = obj.name;
    if (name) {       
      if (name.indexOf(id) == 0) {
			  if( obj.value == 0 ) {
			    obj.value = 1;
			  } else {
			    obj.value = 0;
			  }
			  break;
      }
    }
  }
}

aipo.extcabinet.ajustCheck = function(obj){

  var tr = obj.parentNode.parentNode;
  var checkAddWrtDel = false;
  for (var j = 0, td; td = tr.cells[j]; j++) {
    for (var k = 0, ele; ele = td.childNodes[k]; k++){
      var name = ele.name;
      if (name) {       
        if (name.indexOf("acl[folder_creatable][]") == 0 
         || name.indexOf("acl[file_creatable][]") == 0
         || name.indexOf("acl[writable][]") == 0
         || name.indexOf("acl[deletable][]") == 0 ) {
          if( ele.value == 1 ) {
            checkAddWrtDel = true;
            break;
          }
        }
      }
    }
  }
    
  for (var j = 0, td; td = tr.cells[j]; j++) {
    for (var k = 0, ele; ele = td.childNodes[k]; k++){
      var name = ele.name;
      if (name) {
        if (name.indexOf("acl[readable][]") == 0 ) {
          if( checkAddWrtDel == true ) {   
            ele.value = 1;
          }
        }
         if (name.indexOf("chk_readable") == 0 ) {
           if( checkAddWrtDel == true ) {  
             ele.checked = true;
             ele.disabled = true;
           } else {
             ele.disabled = false;
           }
         }
      }
    }
  }
}

aipo.extcabinet.changeAllCheck = function(obj){

  var now_check;
  var now_value;
  if( obj.value == 1 ) {
    now_check = false;
    now_value = 0;
    obj.value = 0;
  } else {
    now_check = true;
    now_value = 1;
    obj.value = 1;
  }

  var tr = obj.parentNode.parentNode;
  var checkAddWrtDel = false;
  for (var j = 0, td; td = tr.cells[j]; j++) {
    for (var k = 0, ele; ele = td.childNodes[k]; k++){
      var name = ele.name;
      if (name) {       
        if (name.indexOf("acl[folder_creatable][]") == 0 
         || name.indexOf("acl[file_creatable][]") == 0
         || name.indexOf("acl[writable][]") == 0
         || name.indexOf("acl[deletable][]") == 0 ) {
          ele.value = now_value;
        }
        
        if (name.indexOf("chk_folder_creatable") == 0 
         || name.indexOf("chk_file_creatable") == 0
         || name.indexOf("chk_writable") == 0
         || name.indexOf("chk_deletable") == 0 ) {
          ele.checked = now_check;
        }
      }
    }
  }
    
  for (var j = 0, td; td = tr.cells[j]; j++) {
    for (var k = 0, ele; ele = td.childNodes[k]; k++){
      var name = ele.name;
      if (name) {
        if (name.indexOf("acl[readable][]") == 0 ) {
          ele.value = now_value;
        }
        if (name.indexOf("chk_readable") == 0 ) {
          ele.checked = now_check;
          ele.disabled = now_check;
        }
      }
    }
  }
}

aipo.extcabinet.changeGroup = function(link, group, sel) {
  
  if( dojo.byId("destuserDiv") ) {
    if( group == "LoginUser" ) {
      //var html = "";
      //html += '<select name="dest_user_id" id="dest_user_id" style="width:99%;" disabled/>';
      //html += '<option value="ALL">全員に付与</option>';
      //html += '</select>';
      //dojo.byId("destuserDiv").innerHTML = html;
      aimluck.utils.form.createSelect("dest_user_id", "destuserDiv", link + "?mode=group&groupname=" + group + "&inc_luser=false", "userId", "aliasName", sel, '<option value="ALL">（全員に権限設定）<\/option>', 'id="dest_user_id" style="width:99%;"');
    } else {
      aimluck.utils.form.createSelect("dest_user_id", "destuserDiv", link + "?mode=group&groupname=" + group + "&inc_luser=false", "userId", "aliasName", sel, '<option value="GROUP">（グループに権限設定）<\/option>', 'id="dest_user_id" style="width:99%;"');
    }
  }
}
