/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.rss;

import java.util.Date;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * RSS記事の ResultData です。<BR>
 * 
 */
public class RssResultData implements ALData {

  /** Ｆｅｅｄタイトル */
  private ALStringField feedTitle;
  
  /** RSSタイトル */
  private ALStringField title;

  /** 問い合わせ先URL */
  private ALStringField link;
  
  /** 公開日時 */
  private Date publishedDate;

  /**
   * フィールドを初期化します。<BR>
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
  	feedTitle = new ALStringField();
    title = new ALStringField();
    link = new ALStringField();
    publishedDate = new Date();
  }

  public ALStringField getFeedTitle() {
		return feedTitle;
	}

  public void setFeedTitle(String feedTitle) {
		this.feedTitle.setValue(feedTitle);
	}
	
  public ALStringField getLink() {
    return link;
  }

  public ALStringField getTitle() {
    return title;
  }

  public void setLink(String string) {
    link.setValue(string);
  }

  public void setTitle(String string) {
    title.setValue(string);
  }

  public Date getPublishedDate() {
    return publishedDate;
  }

  public void setPublishedDate(Date publishedDate) {
    this.publishedDate = publishedDate;
  }
}
