/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.rss;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * Myリンクの ResultData です。<BR>
 * 
 */
public class UrlResultData implements ALData {

	/** PSMLでの設定の順番 */
	private ALStringField no;
	
  /** RSSタイトル */
  private ALStringField title;

  /** RSS配信URL */
  private ALStringField link;

  /**
   * フィールドを初期化します。<BR>
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
  	no = new ALStringField();
    title = new ALStringField();
    link = new ALStringField();
  }
  
  public ALStringField getNo() {
    return no;
  }

  public ALStringField getLink() {
    return link;
  }

  public ALStringField getTitle() {
    return title;
  }
  
  public void setNo(String string) {
    no.setValue(string);
  }

  public void setLink(String string) {
    link.setValue(string);
  }

  public void setTitle(String string) {
    title.setValue(string);
  }
}
