package org.apache.jetspeed.om.security.turbine;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.map.MapBuilder;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

import com.workingdogs.village.DataSetException;
import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;

// Local classes
import org.apache.jetspeed.om.security.turbine.map.*;


  
  
  
/**
 * This class was autogenerated by Torque on:
 *
 * [Thu Jun 10 23:17:32 JST 2004]
 *
 */
public abstract class BaseTurbineUserGroupRolePeer
    extends BasePeer
{

    /** the default database name for this class */
    public static final String DATABASE_NAME = "default";

     /** the table name for this class */
    public static final String TABLE_NAME = "TURBINE_USER_GROUP_ROLE";

    /**
     * @return the map builder for this peer
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static MapBuilder getMapBuilder()
        throws TorqueException
    {
        return getMapBuilder(TurbineUserGroupRoleMapBuilder.CLASS_NAME);
    }

      /** the column name for the USER_ID field */
    public static final String USER_ID;
      /** the column name for the GROUP_ID field */
    public static final String GROUP_ID;
      /** the column name for the ROLE_ID field */
    public static final String ROLE_ID;
  
    static
    {
          USER_ID = "TURBINE_USER_GROUP_ROLE.USER_ID";
          GROUP_ID = "TURBINE_USER_GROUP_ROLE.GROUP_ID";
          ROLE_ID = "TURBINE_USER_GROUP_ROLE.ROLE_ID";
          if (Torque.isInit())
        {
            try
            {
                getMapBuilder();
            }
            catch (Exception e)
            {
                log.error("Could not initialize Peer", e);
            }
        }
        else
        {
            Torque.registerMapBuilder(TurbineUserGroupRoleMapBuilder.CLASS_NAME);
        }
    }
 
    /** number of columns for this peer */
    public static final int numColumns =  3;

    /** A class that can be returned by this peer. */
    protected static final String CLASSNAME_DEFAULT =
        "org.apache.jetspeed.om.security.turbine.TurbineUserGroupRole";

    /** A class that can be returned by this peer. */
    protected static final Class CLASS_DEFAULT = initClass(CLASSNAME_DEFAULT);

    /**
     * Class object initialization method.
     *
     * @param className name of the class to initialize
     * @return the initialized class
     */
    private static Class initClass(String className)
    {
        Class c = null;
        try
        {
            c = Class.forName(className);
        }
        catch (Throwable t)
        {
            log.error("A FATAL ERROR has occurred which should not "
                + "have happened under any circumstance.  Please notify "
                + "the Torque developers <turbine-torque-dev@jakarta.apache.org> "
                + "and give as many details as possible (including the error "
                + "stack trace).", t);

            // Error objects should always be propogated.
            if (t instanceof Error)
            {
                throw (Error) t.fillInStackTrace();
            }
        }
        return c;
    }

    /**
     * Get the list of objects for a ResultSet.  Please not that your
     * resultset MUST return columns in the right order.  You can use
     * getFieldNames() in BaseObject to get the correct sequence.
     *
     * @param results the ResultSet
     * @return the list of objects
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List resultSet2Objects(java.sql.ResultSet results)
            throws TorqueException
    {
        try
        {
            QueryDataSet qds = null;
            List rows = null;
            try
            {
                qds = new QueryDataSet(results);
                rows = getSelectResults(qds);
            }
            finally
            {
                if (qds != null)
                {
                    qds.close();
                }
            }

            return populateObjects(rows);
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
        catch (DataSetException e)
        {
            throw new TorqueException(e);
        }
    }


  
    /**
     * Method to do inserts.
     *
     * @param criteria object used to create the INSERT statement.
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static ObjectKey doInsert(Criteria criteria)
        throws TorqueException
    {
        return BaseTurbineUserGroupRolePeer
            .doInsert(criteria, (Connection) null);
    }

    /**
     * Method to do inserts.  This method is to be used during a transaction,
     * otherwise use the doInsert(Criteria) method.  It will take care of
     * the connection details internally.
     *
     * @param criteria object used to create the INSERT statement.
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static ObjectKey doInsert(Criteria criteria, Connection con)
        throws TorqueException
    {
                    
        // Set the correct dbName if it has not been overridden
        // criteria.getDbName will return the same object if not set to
        // another value so == check is okay and faster
        if (criteria.getDbName() == Torque.getDefaultDB())
        {
            criteria.setDbName(DATABASE_NAME);
        }
        if (con == null)
        {
            return BasePeer.doInsert(criteria);
        }
        else
        {
            return BasePeer.doInsert(criteria, con);
        }
    }

    /**
     * Add all the columns needed to create a new object.
     *
     * @param criteria object containing the columns to add.
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void addSelectColumns(Criteria criteria)
            throws TorqueException
    {
          criteria.addSelectColumn(USER_ID);
          criteria.addSelectColumn(GROUP_ID);
          criteria.addSelectColumn(ROLE_ID);
      }

    /**
     * Create a new object of type cls from a resultset row starting
     * from a specified offset.  This is done so that you can select
     * other rows than just those needed for this object.  You may
     * for example want to create two objects from the same row.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static TurbineUserGroupRole row2Object(Record row,
                                             int offset,
                                             Class cls)
        throws TorqueException
    {
        try
        {
            TurbineUserGroupRole obj = (TurbineUserGroupRole) cls.newInstance();
            TurbineUserGroupRolePeer.populateObject(row, offset, obj);
                  obj.setModified(false);
              obj.setNew(false);

            return obj;
        }
        catch (InstantiationException e)
        {
            throw new TorqueException(e);
        }
        catch (IllegalAccessException e)
        {
            throw new TorqueException(e);
        }
    }

    /**
     * Populates an object from a resultset row starting
     * from a specified offset.  This is done so that you can select
     * other rows than just those needed for this object.  You may
     * for example want to create two objects from the same row.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void populateObject(Record row,
                                      int offset,
                                      TurbineUserGroupRole obj)
        throws TorqueException
    {
        try
        {
                obj.setUserId(row.getValue(offset + 0).asInt());
                  obj.setGroupId(row.getValue(offset + 1).asInt());
                  obj.setRoleId(row.getValue(offset + 2).asInt());
              }
        catch (DataSetException e)
        {
            throw new TorqueException(e);
        }
    }

    /**
     * Method to do selects.
     *
     * @param criteria object used to create the SELECT statement.
     * @return List of selected Objects
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List doSelect(Criteria criteria) throws TorqueException
    {
        return populateObjects(doSelectVillageRecords(criteria));
    }

    /**
     * Method to do selects within a transaction.
     *
     * @param criteria object used to create the SELECT statement.
     * @param con the connection to use
     * @return List of selected Objects
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List doSelect(Criteria criteria, Connection con)
        throws TorqueException
    {
        return populateObjects(doSelectVillageRecords(criteria, con));
    }

    /**
     * Grabs the raw Village records to be formed into objects.
     * This method handles connections internally.  The Record objects
     * returned by this method should be considered readonly.  Do not
     * alter the data and call save(), your results may vary, but are
     * certainly likely to result in hard to track MT bugs.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List doSelectVillageRecords(Criteria criteria)
        throws TorqueException
    {
        return BaseTurbineUserGroupRolePeer
            .doSelectVillageRecords(criteria, (Connection) null);
    }

    /**
     * Grabs the raw Village records to be formed into objects.
     * This method should be used for transactions
     *
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List doSelectVillageRecords(Criteria criteria, Connection con)
        throws TorqueException
    {
        if (criteria.getSelectColumns().size() == 0)
        {
            addSelectColumns(criteria);
        }

                    
        // Set the correct dbName if it has not been overridden
        // criteria.getDbName will return the same object if not set to
        // another value so == check is okay and faster
        if (criteria.getDbName() == Torque.getDefaultDB())
        {
            criteria.setDbName(DATABASE_NAME);
        }
        // BasePeer returns a List of Value (Village) arrays.  The array
        // order follows the order columns were placed in the Select clause.
        if (con == null)
        {
            return BasePeer.doSelect(criteria);
        }
        else
        {
            return BasePeer.doSelect(criteria, con);
        }
    }

    /**
     * The returned List will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List populateObjects(List records)
        throws TorqueException
    {
        List results = new ArrayList(records.size());

        // populate the object(s)
        for (int i = 0; i < records.size(); i++)
        {
            Record row = (Record) records.get(i);
              results.add(TurbineUserGroupRolePeer.row2Object(row, 1,
                TurbineUserGroupRolePeer.getOMClass()));
          }
        return results;
    }
 

    /**
     * The class that the Peer will make instances of.
     * If the BO is abstract then you must implement this method
     * in the BO.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static Class getOMClass()
        throws TorqueException
    {
        return CLASS_DEFAULT;
    }

    /**
     * Method to do updates.
     *
     * @param criteria object containing data that is used to create the UPDATE
     *        statement.
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void doUpdate(Criteria criteria) throws TorqueException
    {
         BaseTurbineUserGroupRolePeer
            .doUpdate(criteria, (Connection) null);
    }

    /**
     * Method to do updates.  This method is to be used during a transaction,
     * otherwise use the doUpdate(Criteria) method.  It will take care of
     * the connection details internally.
     *
     * @param criteria object containing data that is used to create the UPDATE
     *        statement.
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void doUpdate(Criteria criteria, Connection con)
        throws TorqueException
    {
        Criteria selectCriteria = new Criteria(DATABASE_NAME, 2);
                   selectCriteria.put(USER_ID, criteria.remove(USER_ID));
                       selectCriteria.put(GROUP_ID, criteria.remove(GROUP_ID));
                       selectCriteria.put(ROLE_ID, criteria.remove(ROLE_ID));
      
        // Set the correct dbName if it has not been overridden
        // criteria.getDbName will return the same object if not set to
        // another value so == check is okay and faster
        if (criteria.getDbName() == Torque.getDefaultDB())
        {
            criteria.setDbName(DATABASE_NAME);
        }
        if (con == null)
        {
            BasePeer.doUpdate(selectCriteria, criteria);
        }
        else
        {
            BasePeer.doUpdate(selectCriteria, criteria, con);
        }
    }

    /**
     * Method to do deletes.
     *
     * @param criteria object containing data that is used DELETE from database.
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
     public static void doDelete(Criteria criteria) throws TorqueException
     {
         BaseTurbineUserGroupRolePeer
            .doDelete(criteria, (Connection) null);
     }

    /**
     * Method to do deletes.  This method is to be used during a transaction,
     * otherwise use the doDelete(Criteria) method.  It will take care of
     * the connection details internally.
     *
     * @param criteria object containing data that is used DELETE from database.
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
     public static void doDelete(Criteria criteria, Connection con)
        throws TorqueException
     {
                    
        // Set the correct dbName if it has not been overridden
        // criteria.getDbName will return the same object if not set to
        // another value so == check is okay and faster
        if (criteria.getDbName() == Torque.getDefaultDB())
        {
            criteria.setDbName(DATABASE_NAME);
        }
        if (con == null)
        {
            BasePeer.doDelete(criteria);
        }
        else
        {
            BasePeer.doDelete(criteria, con);
        }
     }

    /**
     * Method to do selects
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List doSelect(TurbineUserGroupRole obj) throws TorqueException
    {
        return doSelect(buildCriteria(obj));
    }

    /**
     * Method to do inserts
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void doInsert(TurbineUserGroupRole obj) throws TorqueException
    {
          doInsert(buildCriteria(obj));
          obj.setNew(false);
        obj.setModified(false);
    }

    /**
     * @param obj the data object to update in the database.
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void doUpdate(TurbineUserGroupRole obj) throws TorqueException
    {
        doUpdate(buildCriteria(obj));
        obj.setModified(false);
    }

    /**
     * @param obj the data object to delete in the database.
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void doDelete(TurbineUserGroupRole obj) throws TorqueException
    {
        doDelete(buildCriteria(obj));
    }

    /**
     * Method to do inserts.  This method is to be used during a transaction,
     * otherwise use the doInsert(TurbineUserGroupRole) method.  It will take
     * care of the connection details internally.
     *
     * @param obj the data object to insert into the database.
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void doInsert(TurbineUserGroupRole obj, Connection con)
        throws TorqueException
    {
          doInsert(buildCriteria(obj), con);
          obj.setNew(false);
        obj.setModified(false);
    }

    /**
     * Method to do update.  This method is to be used during a transaction,
     * otherwise use the doUpdate(TurbineUserGroupRole) method.  It will take
     * care of the connection details internally.
     *
     * @param obj the data object to update in the database.
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void doUpdate(TurbineUserGroupRole obj, Connection con)
        throws TorqueException
    {
        doUpdate(buildCriteria(obj), con);
        obj.setModified(false);
    }

    /**
     * Method to delete.  This method is to be used during a transaction,
     * otherwise use the doDelete(TurbineUserGroupRole) method.  It will take
     * care of the connection details internally.
     *
     * @param obj the data object to delete in the database.
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void doDelete(TurbineUserGroupRole obj, Connection con)
        throws TorqueException
    {
        doDelete(buildCriteria(obj), con);
    }

    /**
     * Method to do deletes.
     *
     * @param pk ObjectKey that is used DELETE from database.
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void doDelete(ObjectKey pk) throws TorqueException
    {
        BaseTurbineUserGroupRolePeer
           .doDelete(pk, (Connection) null);
    }

    /**
     * Method to delete.  This method is to be used during a transaction,
     * otherwise use the doDelete(ObjectKey) method.  It will take
     * care of the connection details internally.
     *
     * @param pk the primary key for the object to delete in the database.
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void doDelete(ObjectKey pk, Connection con)
        throws TorqueException
    {
        doDelete(buildCriteria(pk), con);
    }

    /** Build a Criteria object from an ObjectKey */
    public static Criteria buildCriteria( ObjectKey pk )
    {
        Criteria criteria = new Criteria();
          SimpleKey[] keys = (SimpleKey[])pk.getValue();
                    criteria.add(USER_ID, keys[0]);
                      criteria.add(GROUP_ID, keys[1]);
                      criteria.add(ROLE_ID, keys[2]);
                    return criteria;
     }

    /** Build a Criteria object from the data object for this peer */
    public static Criteria buildCriteria( TurbineUserGroupRole obj )
    {
        Criteria criteria = new Criteria(DATABASE_NAME);
                  criteria.add(USER_ID, obj.getUserId());
                  criteria.add(GROUP_ID, obj.getGroupId());
                  criteria.add(ROLE_ID, obj.getRoleId());
          return criteria;
    }
 
    
    
    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public static TurbineUserGroupRole retrieveByPK(ObjectKey pk)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        Connection db = null;
        TurbineUserGroupRole retVal = null;
        try
        {
            db = Torque.getConnection(DATABASE_NAME);
            retVal = retrieveByPK(pk, db);
        }
        finally
        {
            Torque.closeConnection(db);
        }
        return(retVal);
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public static TurbineUserGroupRole retrieveByPK(ObjectKey pk, Connection con)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        Criteria criteria = buildCriteria(pk);
        List v = doSelect(criteria, con);
        if (v.size() == 0)
        {
            throw new NoRowsException("Failed to select a row.");
        }
        else if (v.size() > 1)
        {
            throw new TooManyRowsException("Failed to select only one row.");
        }
        else
        {
            return (TurbineUserGroupRole)v.get(0);
        }
    }

    /**
     * Retrieve a multiple objects by pk
     *
     * @param pks List of primary keys
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List retrieveByPKs(List pks)
        throws TorqueException
    {
        Connection db = null;
        List retVal = null;
        try
        {
           db = Torque.getConnection(DATABASE_NAME);
           retVal = retrieveByPKs(pks, db);
        }
        finally
        {
            Torque.closeConnection(db);
        }
        return(retVal);
    }

    /**
     * Retrieve a multiple objects by pk
     *
     * @param pks List of primary keys
     * @param dbcon the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List retrieveByPKs( List pks, Connection dbcon )
        throws TorqueException
    {
        List objs = null;
        if (pks == null || pks.size() == 0)
        {
            objs = new LinkedList();
        }
        else
        {
            Criteria criteria = new Criteria();
              Iterator iter = pks.iterator();
            while (iter.hasNext())
            {
                ObjectKey pk = (ObjectKey)iter.next();
                SimpleKey[] keys = (SimpleKey[])pk.getValue();
                            Criteria.Criterion c0 = criteria.getNewCriterion(
                        USER_ID, keys[0], Criteria.EQUAL);
                                    Criteria.Criterion c1 = criteria.getNewCriterion(
                        GROUP_ID, keys[1], Criteria.EQUAL);
                                    c0.and(c1);
                              Criteria.Criterion c2 = criteria.getNewCriterion(
                        ROLE_ID, keys[2], Criteria.EQUAL);
                                    c1.and(c2);
                          criteria.or(c0);
            }
          objs = doSelect(criteria, dbcon);
        }
        return objs;
    }

 
    /**
     * retrieve object using using pk values.
     *
       * @param user_id int
       * @param group_id int
       * @param role_id int
       */
    public static TurbineUserGroupRole retrieveByPK(
       int user_id
          , int group_id
          , int role_id
              ) throws TorqueException
    {
        Connection db = null;
        TurbineUserGroupRole retVal = null;
        try
        {
           db = Torque.getConnection(DATABASE_NAME);
           retVal = retrieveByPK(
         user_id
          , group_id
          , role_id
                     , db);
        }
        finally
        {
            Torque.closeConnection(db);
        }
        return(retVal);
    }

      /**
     * retrieve object using using pk values.
     *
       * @param user_id int
       * @param group_id int
       * @param role_id int
       * @param Connection con
     */
    public static TurbineUserGroupRole retrieveByPK(
       int user_id
          , int group_id
          , int role_id
             ,Connection con) throws TorqueException
    {

        Criteria criteria = new Criteria(5);
          criteria.add(USER_ID, user_id);
          criteria.add(GROUP_ID, group_id);
          criteria.add(ROLE_ID, role_id);
          List v = doSelect(criteria, con);
        if (v.size() != 1)
        {
            throw new TorqueException("Failed to select one and only one row.");
        }
        else
        {
            return (TurbineUserGroupRole) v.get(0);
        }
    }



              
                                              
                
                

    /**
     * selects a collection of TurbineUserGroupRole objects pre-filled with their
     * TurbineUser objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TurbineUserGroupRolePeer.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected static List doSelectJoinTurbineUser(Criteria c)
        throws TorqueException
    {
        // Set the correct dbName if it has not been overridden
        // c.getDbName will return the same object if not set to
        // another value so == check is okay and faster
        if (c.getDbName() == Torque.getDefaultDB())
        {
            c.setDbName(DATABASE_NAME);
        }

        TurbineUserGroupRolePeer.addSelectColumns(c);
        int offset = numColumns + 1;
        TurbineUserPeer.addSelectColumns(c);


                        c.addJoin(TurbineUserGroupRolePeer.USER_ID,
            TurbineUserPeer.USER_ID);
        

                                                              
        List rows = BasePeer.doSelect(c);
        List results = new ArrayList();

        for (int i = 0; i < rows.size(); i++)
        {
            Record row = (Record) rows.get(i);

                            Class omClass = TurbineUserGroupRolePeer.getOMClass();
                    TurbineUserGroupRole obj1 = (TurbineUserGroupRole) TurbineUserGroupRolePeer
                .row2Object(row, 1, omClass);
                     omClass = TurbineUserPeer.getOMClass();
                    TurbineUser obj2 = (TurbineUser)TurbineUserPeer
                .row2Object(row, offset, omClass);

            boolean newObject = true;
            for (int j = 0; j < results.size(); j++)
            {
                TurbineUserGroupRole temp_obj1 = (TurbineUserGroupRole)results.get(j);
                TurbineUser temp_obj2 = (TurbineUser)temp_obj1.getTurbineUser();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTurbineUserGroupRole(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTurbineUserGroupRoles();
                obj2.addTurbineUserGroupRole(obj1);
            }
            results.add(obj1);
        }
        return results;
    }
                                                            
                
                

    /**
     * selects a collection of TurbineUserGroupRole objects pre-filled with their
     * TurbineGroup objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TurbineUserGroupRolePeer.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected static List doSelectJoinTurbineGroup(Criteria c)
        throws TorqueException
    {
        // Set the correct dbName if it has not been overridden
        // c.getDbName will return the same object if not set to
        // another value so == check is okay and faster
        if (c.getDbName() == Torque.getDefaultDB())
        {
            c.setDbName(DATABASE_NAME);
        }

        TurbineUserGroupRolePeer.addSelectColumns(c);
        int offset = numColumns + 1;
        TurbineGroupPeer.addSelectColumns(c);


                        c.addJoin(TurbineUserGroupRolePeer.GROUP_ID,
            TurbineGroupPeer.GROUP_ID);
        

                                                              
        List rows = BasePeer.doSelect(c);
        List results = new ArrayList();

        for (int i = 0; i < rows.size(); i++)
        {
            Record row = (Record) rows.get(i);

                            Class omClass = TurbineUserGroupRolePeer.getOMClass();
                    TurbineUserGroupRole obj1 = (TurbineUserGroupRole) TurbineUserGroupRolePeer
                .row2Object(row, 1, omClass);
                     omClass = TurbineGroupPeer.getOMClass();
                    TurbineGroup obj2 = (TurbineGroup)TurbineGroupPeer
                .row2Object(row, offset, omClass);

            boolean newObject = true;
            for (int j = 0; j < results.size(); j++)
            {
                TurbineUserGroupRole temp_obj1 = (TurbineUserGroupRole)results.get(j);
                TurbineGroup temp_obj2 = (TurbineGroup)temp_obj1.getTurbineGroup();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTurbineUserGroupRole(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTurbineUserGroupRoles();
                obj2.addTurbineUserGroupRole(obj1);
            }
            results.add(obj1);
        }
        return results;
    }
                                                            
                
                

    /**
     * selects a collection of TurbineUserGroupRole objects pre-filled with their
     * TurbineRole objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TurbineUserGroupRolePeer.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected static List doSelectJoinTurbineRole(Criteria c)
        throws TorqueException
    {
        // Set the correct dbName if it has not been overridden
        // c.getDbName will return the same object if not set to
        // another value so == check is okay and faster
        if (c.getDbName() == Torque.getDefaultDB())
        {
            c.setDbName(DATABASE_NAME);
        }

        TurbineUserGroupRolePeer.addSelectColumns(c);
        int offset = numColumns + 1;
        TurbineRolePeer.addSelectColumns(c);


                        c.addJoin(TurbineUserGroupRolePeer.ROLE_ID,
            TurbineRolePeer.ROLE_ID);
        

                                                              
        List rows = BasePeer.doSelect(c);
        List results = new ArrayList();

        for (int i = 0; i < rows.size(); i++)
        {
            Record row = (Record) rows.get(i);

                            Class omClass = TurbineUserGroupRolePeer.getOMClass();
                    TurbineUserGroupRole obj1 = (TurbineUserGroupRole) TurbineUserGroupRolePeer
                .row2Object(row, 1, omClass);
                     omClass = TurbineRolePeer.getOMClass();
                    TurbineRole obj2 = (TurbineRole)TurbineRolePeer
                .row2Object(row, offset, omClass);

            boolean newObject = true;
            for (int j = 0; j < results.size(); j++)
            {
                TurbineUserGroupRole temp_obj1 = (TurbineUserGroupRole)results.get(j);
                TurbineRole temp_obj2 = (TurbineRole)temp_obj1.getTurbineRole();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTurbineUserGroupRole(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTurbineUserGroupRoles();
                obj2.addTurbineUserGroupRole(obj1);
            }
            results.add(obj1);
        }
        return results;
    }
                    
  
                                    
          
        
                                  
                

    /**
     * selects a collection of TurbineUserGroupRole objects pre-filled with
     * all related objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TurbineUserGroupRolePeer.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected static List doSelectJoinAllExceptTurbineUser(Criteria c)
        throws TorqueException
    {
        // Set the correct dbName if it has not been overridden
        // c.getDbName will return the same object if not set to another value
        // so == check is okay and faster
        if (c.getDbName() == Torque.getDefaultDB())
        {
            c.setDbName(DATABASE_NAME);
        }

        addSelectColumns(c);
        int offset2 = numColumns + 1;
                                    
                                                  
                    TurbineGroupPeer.addSelectColumns(c);
        int offset3 = offset2 + TurbineGroupPeer.numColumns;
                                                                
                    TurbineRolePeer.addSelectColumns(c);
        int offset4 = offset3 + TurbineRolePeer.numColumns;
                                                                                                          
        List rows = BasePeer.doSelect(c);
        List results = new ArrayList();

        for (int i = 0; i < rows.size(); i++)
        {
            Record row = (Record)rows.get(i);

                            Class omClass = TurbineUserGroupRolePeer.getOMClass();
                    TurbineUserGroupRole obj1 = (TurbineUserGroupRole)TurbineUserGroupRolePeer
                .row2Object(row, 1, omClass);
                                                
                                                                  
                                                        
                            
              
                           omClass = TurbineGroupPeer.getOMClass();
                          TurbineGroup obj2 = (TurbineGroup)TurbineGroupPeer
                .row2Object( row, offset2, omClass);

               boolean  newObject = true;
            for (int j = 0; j < results.size(); j++)
            {
                TurbineUserGroupRole temp_obj1 = (TurbineUserGroupRole)results.get(j);
                TurbineGroup temp_obj2 = (TurbineGroup)temp_obj1.getTurbineGroup();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTurbineUserGroupRole(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTurbineUserGroupRoles();
                obj2.addTurbineUserGroupRole(obj1);
            }
                                                                    
                                                        
                            
              
                           omClass = TurbineRolePeer.getOMClass();
                          TurbineRole obj3 = (TurbineRole)TurbineRolePeer
                .row2Object( row, offset3, omClass);

               newObject = true;
            for (int j = 0; j < results.size(); j++)
            {
                TurbineUserGroupRole temp_obj1 = (TurbineUserGroupRole)results.get(j);
                TurbineRole temp_obj3 = (TurbineRole)temp_obj1.getTurbineRole();
                if (temp_obj3.getPrimaryKey().equals(obj3.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj3.addTurbineUserGroupRole(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj3.initTurbineUserGroupRoles();
                obj3.addTurbineUserGroupRole(obj1);
            }
                                                results.add(obj1);
        }
        return results;
    }
        
        
                                  
                

    /**
     * selects a collection of TurbineUserGroupRole objects pre-filled with
     * all related objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TurbineUserGroupRolePeer.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected static List doSelectJoinAllExceptTurbineGroup(Criteria c)
        throws TorqueException
    {
        // Set the correct dbName if it has not been overridden
        // c.getDbName will return the same object if not set to another value
        // so == check is okay and faster
        if (c.getDbName() == Torque.getDefaultDB())
        {
            c.setDbName(DATABASE_NAME);
        }

        addSelectColumns(c);
        int offset2 = numColumns + 1;
                                    
                    TurbineUserPeer.addSelectColumns(c);
        int offset3 = offset2 + TurbineUserPeer.numColumns;
                                                                
                                                  
                    TurbineRolePeer.addSelectColumns(c);
        int offset4 = offset3 + TurbineRolePeer.numColumns;
                                                                                                          
        List rows = BasePeer.doSelect(c);
        List results = new ArrayList();

        for (int i = 0; i < rows.size(); i++)
        {
            Record row = (Record)rows.get(i);

                            Class omClass = TurbineUserGroupRolePeer.getOMClass();
                    TurbineUserGroupRole obj1 = (TurbineUserGroupRole)TurbineUserGroupRolePeer
                .row2Object(row, 1, omClass);
                                                
                                                        
                            
              
                           omClass = TurbineUserPeer.getOMClass();
                          TurbineUser obj2 = (TurbineUser)TurbineUserPeer
                .row2Object( row, offset2, omClass);

               boolean  newObject = true;
            for (int j = 0; j < results.size(); j++)
            {
                TurbineUserGroupRole temp_obj1 = (TurbineUserGroupRole)results.get(j);
                TurbineUser temp_obj2 = (TurbineUser)temp_obj1.getTurbineUser();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTurbineUserGroupRole(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTurbineUserGroupRoles();
                obj2.addTurbineUserGroupRole(obj1);
            }
                                                                    
                                                                  
                                                        
                            
              
                           omClass = TurbineRolePeer.getOMClass();
                          TurbineRole obj3 = (TurbineRole)TurbineRolePeer
                .row2Object( row, offset3, omClass);

               newObject = true;
            for (int j = 0; j < results.size(); j++)
            {
                TurbineUserGroupRole temp_obj1 = (TurbineUserGroupRole)results.get(j);
                TurbineRole temp_obj3 = (TurbineRole)temp_obj1.getTurbineRole();
                if (temp_obj3.getPrimaryKey().equals(obj3.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj3.addTurbineUserGroupRole(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj3.initTurbineUserGroupRoles();
                obj3.addTurbineUserGroupRole(obj1);
            }
                                                results.add(obj1);
        }
        return results;
    }
        
        
                                  
                

    /**
     * selects a collection of TurbineUserGroupRole objects pre-filled with
     * all related objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TurbineUserGroupRolePeer.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected static List doSelectJoinAllExceptTurbineRole(Criteria c)
        throws TorqueException
    {
        // Set the correct dbName if it has not been overridden
        // c.getDbName will return the same object if not set to another value
        // so == check is okay and faster
        if (c.getDbName() == Torque.getDefaultDB())
        {
            c.setDbName(DATABASE_NAME);
        }

        addSelectColumns(c);
        int offset2 = numColumns + 1;
                                    
                    TurbineUserPeer.addSelectColumns(c);
        int offset3 = offset2 + TurbineUserPeer.numColumns;
                                                                
                    TurbineGroupPeer.addSelectColumns(c);
        int offset4 = offset3 + TurbineGroupPeer.numColumns;
                                                                
                                                                                            
        List rows = BasePeer.doSelect(c);
        List results = new ArrayList();

        for (int i = 0; i < rows.size(); i++)
        {
            Record row = (Record)rows.get(i);

                            Class omClass = TurbineUserGroupRolePeer.getOMClass();
                    TurbineUserGroupRole obj1 = (TurbineUserGroupRole)TurbineUserGroupRolePeer
                .row2Object(row, 1, omClass);
                                                
                                                        
                            
              
                           omClass = TurbineUserPeer.getOMClass();
                          TurbineUser obj2 = (TurbineUser)TurbineUserPeer
                .row2Object( row, offset2, omClass);

               boolean  newObject = true;
            for (int j = 0; j < results.size(); j++)
            {
                TurbineUserGroupRole temp_obj1 = (TurbineUserGroupRole)results.get(j);
                TurbineUser temp_obj2 = (TurbineUser)temp_obj1.getTurbineUser();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTurbineUserGroupRole(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTurbineUserGroupRoles();
                obj2.addTurbineUserGroupRole(obj1);
            }
                                                                    
                                                        
                            
              
                           omClass = TurbineGroupPeer.getOMClass();
                          TurbineGroup obj3 = (TurbineGroup)TurbineGroupPeer
                .row2Object( row, offset3, omClass);

               newObject = true;
            for (int j = 0; j < results.size(); j++)
            {
                TurbineUserGroupRole temp_obj1 = (TurbineUserGroupRole)results.get(j);
                TurbineGroup temp_obj3 = (TurbineGroup)temp_obj1.getTurbineGroup();
                if (temp_obj3.getPrimaryKey().equals(obj3.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj3.addTurbineUserGroupRole(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj3.initTurbineUserGroupRoles();
                obj3.addTurbineUserGroupRole(obj1);
            }
                                                                    
                                              results.add(obj1);
        }
        return results;
    }
                    
  
      /**
     * Returns the TableMap related to this peer.  This method is not
     * needed for general use but a specific application could have a need.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected static TableMap getTableMap()
        throws TorqueException
    {
        return Torque.getDatabaseMap(DATABASE_NAME).getTable(TABLE_NAME);
    }
   }
