.\" DO NOT MODIFY THIS FILE! it was generated by rd2
.TH CUTTER 1 "October 2011" "Cutter" "Cutter's manual"
.SH NAME
.PP
cutter \- xUnit family unit testing framework for C and C++
.SH SYNOPSIS
.PP
\&\fBcutter\fP [\fIoption ...\fP] \fItest\-directory\fP
.PP
\&\fBcutter\fP \-\-mode=analyze [\fIoption ...\fP] \fIlog\-directory\fP
.SH DESCRIPTION
.PP
Cutter is a xUnit family unit testing framework for C and C++. Cutter provides programmers two important interfaces:
.TP
1.
easy to write API
.TP
2.
easy to debug UI
.PP
Cutter helps programmers to write their new tests, run their existing tests, get feedbacks from ran their tests.
.PP
\fItest\-directory\fP is a directory which has test_*.so. test_*.so are searched recursively.
.PP
\fIlog\-directory\fP is a directory which has Cutter log files. Cutter logs test results when \-\-stream\-directory option is specified.
.SH OPTIONS
.TP
.fi
.B
\-\-version
Cutter shows its own version and exits.
.TP
.fi
.B
\-\-mode=[test|analyze]
It specifies run mode. Cutter runs tests when run mode is test. Cutter analyzes test results when run mode is analyze.

The default is test.
.TP
.fi
.B
\-s DIRECTORY, \-\-source\-directory=DIRECTORY
Cutter prepends DIRECTORY to file name when test fails. This is for tolls (like Emacs) which have function jumping to error line.
.TP
.fi
.B
\-t TEST_CASE_NAME, \-\-test\-case=TEST_CASE_NAME
Cutter runs test cases that are matched with TEST_CASE_NAME. If TEST_CASE_NAME is surrounded by "/" (e.g. /test_/), TEST_CASE_NAME is handled as regular expression.

This option can be specified n times. In the case, Cutter runs test cases that are matched with any TEST_CASE_NAME. (OR)
.TP
.fi
.B
\-n TEST_NAME, \-\-name=TEST_NAME
Cutter runs tests that are matched with TEST_NAME. If TEST_NAME is surrounded by "/" (e.g. /test_/), TEST_NAME is handled as regular expression.

This option can be specified n times. In the case, Cutter runs test that are matched with any TEST_NAME. (OR)
.TP
.fi
.B
\-m, \-\-multi\-thread
Cutter runs a test case in a new thread.

The default is off.
.TP
.fi
.B
\-\-max\-threads=MAX_THREADS
Run test cases and iterated tests with MAX_THREADS threads concurrently at a maximum. \-1 means no limit.

The default is 10.
.TP
.fi
.B
\-\-disable\-signal\-handling
Disable signal handling that provides aborting test by C\-c, provides backtrace on SEGV and so on. If your test target uses signal, Cutter's signal handling may cause a problem. In the case, you should disable Cutter's signal handling by this option.

The default is enabled.
.TP
.fi
.B
\-\-test\-case\-order=[none|name|name\-desc]
It specifies test case order.

If 'none' is specified, Cutter doesn't sort. If 'name' is specified, Cutter sorts test cases by name in ascending order. If 'name\-desc' is specified, Cutter sorts test cases by name in descending order.

The default is none.
.TP
.fi
.B
\-\-exclude\-file=FILE
Cutter doesn't read FILE on test collecting.
.TP
.fi
.B
\-\-exclude\-directory=DIRECTORY
Cutter doesn't search tests under DIRECTORY.
.TP
.fi
.B
\-\-fatal\-failures
Cutter treats failures as fatal problem. It means that Cutter stops test run.

The default is off.
.TP
.fi
.B
\-\-keep\-opening\-modules
Cutter keeps opening loaded modules to resolve symbols for debugging.

The default is off.
.TP
.fi
.B
\-\-enable\-convenience\-attribute\-definition
It enables convenience but danger "#{ATTRIBUTE_NAME}_#{TEST_NAME \- 'test_' PREFIX}" attribute set function.

The default is off.
.TP
.fi
.B
\-\-stop\-before\-test
It sets a breakpoint immediately before each test. You can dive into test function easily by running cutter on your debugger and stepping into the next function.

The default is off.
.TP
.fi
.B
\-u[console|gtk], \-\-ui=[console|gtk]
It specifies UI.

The default is console UI.
.TP
.fi
.B
\-v[s|silent|n|normal|v|verbose], \-\-verbose=[s|silent|n|normal|v|verbose]
It specifies verbose level.

This option is only for console UI.
.TP
.fi
.B
\-c[yes|true|no|false|auto], \-\-color=[yes|true|no|false|auto]
If 'yes' or 'true' is specified, Cutter uses colorized output by escape sequence. If 'no' or 'false' is specified, Cutter never use colorized output. If 'auto' or the option is omitted, Cutter uses colorized output if available.

This option is only for console UI.
.TP
.fi
.B
\-\-pdf\-report=FILE
Cutter outputs a test report to FILE as PDF format.
.TP
.fi
.B
\-\-xml\-report=FILE
Cutter outputs a test report to FILE as XML format.
.TP
.fi
.B
\-\-stream=[xml]
It specifies stream backend. Stream backend streams test results.

There is only XML stream backend for now.
.TP
.fi
.B
\-\-stream\-fd=FILE_DESCRIPTOR
It specifies output file descriptor. The XML stream backend streams to FILE_DESCRIPTOR.

This option is only for XML stream backend.
.TP
.fi
.B
\-\-stream\-directory=DIRECTORY
It specifies output directory. The XML stream backend streams to a file under DIRECTORY.

This option is only for XML stream backend.
.TP
.fi
.B
\-?, \-\-help
Cutter shows common options.
.TP
.fi
.B
\-\-help\-stream
Cutter shows stream related options.
.TP
.fi
.B
\-\-help\-report
Cutter shows report related options.
.TP
.fi
.B
\-\-help\-ui
Cutter shows UI related options.
.TP
.fi
.B
\-\-help\-all
Cutter shows all options.
.SH EXIT STATUS
.PP
The exit status is 0 if all tests are passed and non\-0 otherwise.  Omission test result and notification test result are not treated as failure.
.SH FILES
.TP
.fi
.B
/usr/local/share/doc/cutter/
The directory has Cutter documents. e.g. reference manual, tutorial and so on.
.SH EXAMPLE
.PP
In the following example, cutter runs tests under tests/ directory and shows test progress verbosely.
.nf
\&    % cutter \-v v test/
.fi
.PP
In the following example, test results are saved under logs/ directory:
.nf
\&    % cutter \-\-stream=xml \-\-stream\-directory=logs/ test/
.fi
.SH SEE ALSO
.PP
GLib's reference manual.

