#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int lambda_id = 0;

char* fread_wm(FILE *fp)     //read with malloc
{
	char *str = NULL;
	int size = 10;
	int i = 0;
	if((str = malloc(sizeof(char) * 10)) == NULL){
		printf("memory error\n");
		exit(0);
	}
	
	while((str[i] = (char)fgetc(fp)) != EOF){
		if(i % 10 == 0){
			size += 10;
			if((str = realloc(str,sizeof(char) * (size + 1))) == NULL){
				printf("memory error\n");
				exit(0);
			}
		}
		i++;
	}
	str[i] = '\0';
	return str;
}

char* strrep_wm(char *str,char *str2,int s,int e)    //replace
{
	int size = strlen(str);
	char *rstr = NULL;
	char *tmp = NULL;
	
	if((rstr = malloc(sizeof(char) * (size - e))) == NULL){
		printf("memory error\n");
		exit(0);
	}
	
	strcpy(rstr,&str[e + 1]);
	tmp = str;
	if((str = malloc(sizeof(char) * (size + strlen(str2) + 1))) == NULL){
		printf("memory error\n");
		exit(0);
	}
	strcpy(str,tmp);
	str[s] = '\0';
	str = strcat(strcat(str,str2),rstr);
	free(rstr);
	return str;
}

char* strget_wm(char *str,int s,int e)
{
	char *str2 = NULL;
	
	if((str2 = malloc(sizeof(char) * (strlen(str) + 1))) == NULL){
		printf("memory error\n");
		exit(0);
	}
	strcpy(str2,&str[s]);
	str2[e - s + 1] = '\0';
	str2 = realloc(str2,sizeof(char) * (strlen(str2) + 1));
	return str2;
}

int find_e(char *str,int s)
{
	int i = s + 1;
	int s_f = 0;
	int b_f = 1;
	
	while(str[i] != '\0' && b_f > 0){
		if(str[i] == '\"'){
			if(s_f == 0){
				s_f = 1;
			}
			else{
				s_f = 0;
			}
		}
		if(s_f == 0){
			if(str[i] == '(' || str[i] == '{' || str[i] == '['){
				b_f++;
			}
			else if(str[i] == ')' || str[i] == '}' || str[i] == ']'){
				b_f--;
			}
		}
		i++;
	}
	return i - 1;
}

char* make_func(char *name,char *ret,char *argv,char *block,char *code)
{
	char *code2 = NULL;
	char *init = NULL;
	char *tmp = NULL;
	
	if((code2 = malloc(sizeof(char) * (strlen(ret) + strlen(name) + strlen(argv) + strlen(block) + 30))) == NULL){
		printf("memory error\n");
		exit(0);
	}
	
	sprintf(code2,"\n%s %s(%s){%s}\n",ret,name,argv,block);
	tmp = code;
	if((code = malloc(sizeof(char) * (strlen(code) + strlen(code2) + 1))) == NULL){
		printf("memory error\n");
		exit(0);
	}
	strcpy(code,tmp);
	code = strcat(code,code2);
	free(code2);
	
	if((init = malloc(sizeof(char) * (strlen(name) + strlen(ret) + strlen(argv) + 30 + strlen(code)))) == NULL){
		printf("memory error\n");
		exit(0);
	}
	sprintf(init,"%s %s(%s);\n%s",ret,name,argv,code);
	return init;
}

char* analysis(char *block,char *name,char *code)
{
	int n = 0;
	char *ret_and_argv;
	char *ret;
	char *argv;
	char *block2;
	char *block3;
	char *func;

	int i = 0;
	
	while(block[i] != ')'){
		i++;
	}
	n = strlen(block);
	ret_and_argv = strget_wm(block,2,i - 1);
	block2 = strget_wm(block,i + 1,strlen(block) - 2);    //lambda֐̃ubN
	
	if((n = (int)strstr(ret_and_argv,":")) == NULL){
		return NULL;
	}
	n -= (int)ret_and_argv;
	ret = strget_wm(ret_and_argv,0,n - 1);
	argv = strget_wm(ret_and_argv,n + 1,strlen(ret_and_argv) - 1);
	
	if((block3 = malloc(sizeof(char) * (strlen(block2) + 2))) == NULL){
		printf("memory error\n");
		exit(0);
	}
	sprintf(block3,"%s;",block2);
	
	free(ret_and_argv);
	free(block2);
	func = make_func(name,ret,argv,block3,code);
	free(ret);
	free(argv);
	free(block3);
	return func;
}

char* lambda_tr(char *code)
{
	int s = 0;
	int e = 0;
	char lambda[50];
	char *block;
	char *code2 = NULL;
	
	while(1){
		s = 0;
		e = 0;
		
		if((s = (int)strstr(code,"{(")) == NULL){
			return code;
		}
		s -= (int)code;
		e = find_e(code,s);
		sprintf(lambda,"_lambda%d",lambda_id);
		lambda_id++;
		block = strget_wm(code,s,e);
		code2 = strrep_wm(code,lambda,s,e);
		free(code);
		code = code2;
		
		code2 = analysis(block,lambda,code);
		free(code);
		code = code2;
		free(block);
	}
}

int main(int argc, char* argv[])
{
	FILE *fp = NULL;
	char *code;
	char fn[256];
	int i = 0;
	int j = 0;
	
	if(argc < 2){
		printf("error:argv error\n");
		return 0;
	}

	for(i = 1;i < argc;i++){
		fp = fopen(argv[i],"r");
		if(fp == NULL){
			printf("error:file open error:%s\n",argv[i]);
			return 0;
		}
		code = fread_wm(fp);
		fclose(fp);
		code = lambda_tr(code);
		
		sprintf(fn,"%s.c",argv[i]);
		if((fp = fopen(fn,"w")) == NULL){
			printf("error:file open error:%s\n",fn);
			return 0;
		}
		for(j = 0;code[j] != '\0';j++){
			fputc(code[j],fp);
		}
		fclose(fp);
		free(code);
	}
	return 0;
}
