#!/bin/ksh
#
# manual.ksh(0)
#
#
#  名称
#      manual.ksh
#      
#  概要
#      ＵＮＩＸレファレンスマニュアルのトピック化
#      
#  構文
#      manual.ksh section-name manual-name
#      
#  説明
#      ＵＮＩＸのレファレンスマニュアルの関連する項目をホットスポット化してｔ
#      ｏｐｉｃにパイプします。
#      このコマンドは topic(0) がＵＮＩＸマニュアルページの参照項目をトピック
#      として扱うとき子プロセスとして実行するために作成しました。つまり topic
#      (0) の実行は再帰的に行われることになります。このとき /tmp ディレクトリ
#      に一時ファイルが作成されます。
#      
#      各ＵＮＩＸ機種毎に相違するディレクトリ名／ファイル名や環境、ホットスポ
#      ット変換の調整はこのスクリプトで行って下さい。ｔｏｐｉｃの画面表示の変
#      更もここで行います。
#      ＵＮＩＸの man コマンドの代用となります。
#      本プログラムはシェルスクリプトです。
#      
#      
#  多言語化対応
#      ＨＰ９０００では日本語／英語の切替を環境変数 LANGUAGE で行えます。
#      ＵＮＩＳＹＳ６０００では gen 386 unisys の優先順位でディレクトリが検索
#      されます。
#      
#  診断
#      
#  例
#      manual 1 ksh | topic -c64 -w40 -l22 -x5 -y1 -e
#      
#  参照
#      [7msh(1)[m, [7mksh(1)[m, [7msed(1)[m
#      [7mnroff(1)[m, [7mtbl(1)[m, [7mman(1)[m
#      [7mul(1)[m, [7mneqn(1)[m, [7mcol(1)[m
#      [7mcurses(3x)[m
#      
#  バグ
#      参照項目のホットスポット化が成功しない例が存在した場合は sed -e に続く
#      スクリプトに追加変更を行って下さい。
#      正規表現を多用しているので注意して変更を行って下さい。
#      エスケープシーケンスを使用しているため CURSES により行末が強制的にちじ
#      めれた場合は w オプションを利用して仮想桁を増やして下さい。
#      端末により反転表示やアンダーライン表示が出来ない場合には -e オプション
#      で CURSES 属性の使用をオンにして下さい。
#      
#      
#  著者
#      manual.ksh は Shigeki Ono によって開発されました。
#      
#  標準準拠
#      
#
#
#  作者後書
#
#      UNIX のマニュアルはシステムにより構成が違うことが多いためこのシェル
#      スクリプトの使用を推奨します。
#      KSHの機能は whence のみ使用していますので SH だけのシステムでもわず
#      かな変更ですみます。
#      なお正規表現の変更については [7msed(1)[m のマニュアルを参考にし
#      て下さい。
#
#      New routin 1996(C) S.Ono
#

export PATH=".:$PATH:${CMSPATH}/bin"

TMP=/tmp
Lang=.
Kanji=SJIS
Section=
Doc=
D=
Ignore=
Option=
Ttyname=


#実行ファイルがパスに存在するか確かめる
whence topic > /dev/null
if [ $? != 0 ]
then
	exit
fi

#システムコンソールで実行した場合は curses 属性を使用する
#Ttyname=`tty`
#if [ ${Ttyname} = "/dev/console" ]
#then
#	Option="-e"
#fi

Option="-e"

#日本語マニュアルを表示するかどうか環境変数を調べる
echo "${NLS_LANG}" | grep -l "Japan"
if [ $? = 0 ]
then
	Lang=japanese
else
	Lang=.
fi
if(`echo "${NLS_LANG}" | grep -l "SJIS"`) then
	Kanji=
else
	Kanji=
fi

# -k オプションつまりキーワードは不要のため削除した
case $1 in
"k"|"K"|"-k"|"-K") exit;;
*);;
esac

#マニュアルはセクションと名前を選択する
case $# in
0) exit;;
1) Section=1;Doc=$1;;
2)	Ignore=$1;
	Section=`echo $1 | tr [A-Z] [a-z]`;
	Doc=$2;
	;;
*);;
esac

#セクション名はディレクトリの追加文字
D=`echo $Section | cut -c1`

#trap 'chmod 440 ${Source}/${Tree};exit'1 2 3 4 5 6 7 8 9 15
trap 'rm -f ${TMP}/topic$$.tmp;rm -i ${TMP}/topic$$.tmp;exit' 1 2 3 4 5 6 7 8 9 15

#ディレクトリにマニュアルが存在するかどうか調べ、あればテンポラリにコピーする
if [ ! -f /usr/share/man/${Lang}${Kanji}/man${D}/${Doc}.${Section} ]
then
	if [ -f /usr/share/man/${Lang}${Kanji}/man${D}m/${Doc}.${Section} ]
	then
		cp /usr/share/man/${Lang}${Kanji}/man${D}m/${Doc}.${Section} ${TMP}/topic$$.tmp
	else
		if [ -f /usr/share/man/${Lang}${Kanji}/man${D}/${Doc}.${Ignore} ]
		then
			cp /usr/share/man/${Lang}${Kanji}/man${D}/${Doc}.${Ignore} ${TMP}/topic$$.tmp
		else
			exit
		fi
	fi
else
	cp /usr/share/man/${Lang}${Kanji}/man${D}/${Doc}.${Section} ${TMP}/topic$$.tmp
fi

# マニュアルの参照項目全てをトピックとして表示する
# トピック表示は topic -w[0-120] で調整可能
# topic のオプションについての詳細は Usage: を参照して下さい
#
# 正規表現の変更追加でトピック表示を調整できます。
#
tbl -TX ${TMP}/topic$$.tmp | neqn | nroff -man | col -x |
sed -e s/.//g \
-e s/_//g \
-e s///g \
-e 's/)[ ][ ]*.*[ ].*)$/)/g' \
-e '/^ [a-z][a-z]*(/s/$/\[m/' \
-e '/^ [A-Z][A-Z]*(/s/$/\[m/' \
-e '/^ [A-Za-z][A-Za-z]*[A-Za-z][A-Za-z]*(/s/$/\[m/' \
-e '/([0-9]/s/$/\[m/' \
-e '/([0-9]/,/$/s/,/\[m/g' \
-e '/([0-9]/,/$/s/、/  \[m/g' \
-e '/([0-9]/,/$/s/)/)\[m/g' \
-e 's/^\[m$//' \
-e 's/\[m\[m/\[m/g' \
-e '/!([0-9]/s/[\[m]*$//' \
-e '/!([0-9]/s/\[m//' \
-e '/([0-9]/s/[a-z][a-z]*[0-9](/\[7m&/g' \
-e '/([0-9]/s/[a-z][a-z]*[0-9][0-9](/\[7m&/g' \
-e '/([0-9]/s/[a-z][a-z]*[0-9]*_[a-z][a-z]*(/\[7m&/g' \
-e '/([0-9]/s/[a-z][a-z]*_[0-9][0-9]*(/\[7m&/g' \
-e '/([0-9]/s/[a-z][a-z]*[0-9][0-9]*_[0-9][0-9]*(/\[7m&/g' \
-e '/([0-9]/s/.*_.*_.*(/\[7m&/g' \
-e '/([0-9]/s/[a-z][a-z]*\.[a-z][a-z]*(/&/g' \
-e '/([0-9]/s/ [a-z]\..*(/\[7m&/g' \
-e '/([0-9]/s/.*\-.*(/\[7m&/g' \
-e '/([0-9]/s/[a-zA-Z][a-zA-Z]*(/\[7m&/g' | topic -w60 ${Option}
#-e '/([0-9]/s/[A-Z][A-Z]*[a-z][a-z]*[A-Z][A-Z]*[a-z][a-z]*(/\[7m&/g' \
#-e '/([0-9]/s/[A-Za-z][A-Za-z]*[A-Za-z][A-Za-z]*[A-Za-z][A-Za-z]*(/\[7m&/g' \

 rm -f ${TMP}/topic$$.tmp

