#!/bin/ksh
#
#	MKBASE.KSH
#	All Rights Reserved 1992,99 (C)
#

export PATH=".:$PATH:${CMSPATH}/bin"

DiffDir=${CMSPATH}/diff
UserDir=${CMSPATH}/fusr
basedir=`basename ${PWD}`

echo "作成するシステム名を入力: \c"
read SYSNAME
if [ x"$basedir" != x"${SYSNAME}" ]
then
	errmsg "システム名とベースディレクトリ名が違います"
	exit
else
	TABFILE="${SYSNAME}tab"
	Tabfile=${CMSPATH}/diff/tabs/${TABFILE}
fi
if [ ! -f ${TABFILE} ]
then
	errmsg "ソーステーブルファイル ${TABFILE}  が作成されていません"
	exit
else
	cp -p ${TABFILE} ${DiffDir}/tabs
fi

grep -l "${SYSNAME}" ${DiffDir}/userfile
if [ $? = 1 ]
then
	echo "${SYSNAME}" >> ${DiffDir}/userfile
else
	errmsg "${SYSNAME} は存在するシステム名です"
fi

echo "作成するバージョンを入力[1 - 10]: \c"
read KEIVER
if [ ${KEIVER} -gt 9 -o x"${KEIVER}" = x"" ]
then
	errmsg "バージョン番号 ${KEIVER} は使用出来ません"
	exit
else
	if [ ! -f ${UserDir}/${SYSNAME}/.profile ]
	then
		cat ${DiffDir}/.profile | sed -e 's/XXX/'${SYSNAME}'/g' -e 's/KEIVER=1/'KEIVER=${KEIVER}'/g' > ${UserDir}/${SYSNAME}/.profile
		cp ${DiffDir}/.exrc ${UserDir}/${SYSNAME}
	fi
fi

for i in `cat ${Tabfile}`
do
	if [ ! -f ${CMSPATH}/siten/${SYSNAME}/$i ]
	then
		cmp $i ${CMSPATH}/siten/${SYSNAME}/$i 2> /dev/null
		if [ $? = 2 ]
		then
			if [ ! -d ${CMSPATH}/siten/${SYSNAME} ]
			then
				mkdir2 ${CMSPATH}/siten/${SYSNAME}
			fi
			cat ${TABFILE} | cpio -pdumv ${CMSPATH}/siten/${SYSNAME}
		fi
	fi
	if [ ! -f ${CMSPATH}/src/${SYSNAME}/$i ]
	then
		cmp $i ${CMSPATH}/src/${SYSNAME}/$i 2> /dev/null
		if [ $? = 2 ]
		then
			if [ ! -d ${CMSPATH}/src/${SYSNAME} ]
			then
				mkdir2 ${CMSPATH}/src/${SYSNAME}
				mkdir2 ${CMSPATH}/sub/ver_${KEIVER}/${SYSNAME}
				mkdir2 ${CMSPATH}/man/${SYSNAME}
			fi
			cat ${TABFILE} | cpio -pdumv ${CMSPATH}/src/${SYSNAME}
		fi
	fi
done
